/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext;

import io.jenetics.Chromosome;
import io.jenetics.Genotype;
import io.jenetics.Phenotype;
import io.jenetics.Recombinator;
import io.jenetics.ext.TreeGene;
import io.jenetics.ext.util.FlatTree;
import io.jenetics.ext.util.FlatTreeNode;
import io.jenetics.ext.util.Tree;
import io.jenetics.ext.util.TreeNode;
import io.jenetics.util.ISeq;
import io.jenetics.util.MSeq;
import io.jenetics.util.RandomRegistry;
import java.util.Random;

public abstract class TreeCrossover<G extends TreeGene<?, G>, C extends Comparable<? super C>>
extends Recombinator<G, C> {
    protected TreeCrossover(double probability2) {
        super(probability2, 2);
    }

    protected int recombine(MSeq<Phenotype<G, C>> population, int[] individuals, long generation) {
        assert (individuals.length == 2) : "Required order of 2";
        Random random2 = RandomRegistry.getRandom();
        Phenotype pt1 = (Phenotype)population.get(individuals[0]);
        Phenotype pt2 = (Phenotype)population.get(individuals[1]);
        Genotype gt1 = pt1.getGenotype();
        Genotype gt2 = pt2.getGenotype();
        int chIndex = random2.nextInt(Math.min(gt1.length(), gt2.length()));
        MSeq c1 = gt1.toSeq().copy();
        MSeq c2 = gt2.toSeq().copy();
        this.crossover(c1, c2, chIndex);
        population.set(individuals[0], (Object)Phenotype.of((Genotype)Genotype.of((Iterable)c1.toISeq()), (long)generation));
        population.set(individuals[1], (Object)Phenotype.of((Genotype)Genotype.of((Iterable)c2.toISeq()), (long)generation));
        return this.getOrder();
    }

    private <A> void crossover(MSeq<Chromosome<G>> c1, MSeq<Chromosome<G>> c2, int index) {
        TreeNode tree1 = TreeNode.ofTree((Tree)((Chromosome)c1.get(index)).getGene());
        TreeNode tree2 = TreeNode.ofTree((Tree)((Chromosome)c2.get(index)).getGene());
        this.crossover(tree1, tree2);
        FlatTreeNode flat1 = FlatTreeNode.of(tree1);
        FlatTreeNode flat2 = FlatTreeNode.of(tree2);
        TreeGene template = (TreeGene)((Chromosome)c1.get(0)).getGene();
        ISeq<TreeGene> genes1 = flat1.map(tree -> this.gene(template, (FlatTree)tree));
        ISeq<TreeGene> genes2 = flat2.map(tree -> this.gene(template, (FlatTree)tree));
        c1.set(index, (Object)((Chromosome)c1.get(index)).newInstance(genes1));
        c2.set(index, (Object)((Chromosome)c2.get(index)).newInstance(genes2));
    }

    private <A> G gene(TreeGene<A, ?> template, FlatTree<? extends A, ?> tree) {
        return (G)template.newInstance(tree.getValue(), tree.childOffset(), tree.childCount());
    }

    protected abstract <A> int crossover(TreeNode<A> var1, TreeNode<A> var2);
}

