/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext;

import io.jenetics.AltererResult;
import io.jenetics.Chromosome;
import io.jenetics.Gene;
import io.jenetics.Genotype;
import io.jenetics.Mutator;
import io.jenetics.MutatorResult;
import io.jenetics.Phenotype;
import io.jenetics.util.ISeq;
import io.jenetics.util.RandomRegistry;
import io.jenetics.util.Seq;
import java.util.Random;

public class WeaselMutator<G extends Gene<?, G>, C extends Comparable<? super C>>
extends Mutator<G, C> {
    public WeaselMutator(double probability2) {
        super(probability2);
    }

    public WeaselMutator() {
        this(0.05);
    }

    public AltererResult<G, C> alter(Seq<Phenotype<G, C>> population, long generation) {
        Random random2 = RandomRegistry.getRandom();
        Seq result = population.map(pt -> this.mutate((Phenotype)pt, generation, this._probability, random2));
        return AltererResult.of((ISeq)result.map(MutatorResult::getResult).asISeq(), (int)result.stream().mapToInt(MutatorResult::getMutations).sum());
    }

    protected MutatorResult<Genotype<G>> mutate(Genotype<G> genotype, double p, Random random2) {
        ISeq result = genotype.toSeq().map(gt -> this.mutate((Chromosome)gt, p, random2));
        return MutatorResult.of((Object)Genotype.of((Iterable)result.map(MutatorResult::getResult)), (int)result.stream().mapToInt(MutatorResult::getMutations).sum());
    }

    public String toString() {
        return String.format("WeaselMutator[%f]", this._probability);
    }
}

