/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.internal;

import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ConcatSpliterator<T>
implements Spliterator<T> {
    private final Deque<Spliterator<T>> _spliterators;

    public ConcatSpliterator(Collection<Spliterator<T>> spliterators) {
        this._spliterators = new LinkedList<Spliterator<T>>(spliterators);
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        boolean advance = true;
        if (!this._spliterators.isEmpty()) {
            Spliterator<? super T> spliterator = this._spliterators.peek();
            assert (spliterator != null);
            if (!spliterator.tryAdvance(action)) {
                this._spliterators.removeFirst();
                advance = !this._spliterators.isEmpty();
            }
        } else {
            advance = false;
        }
        return advance;
    }

    @Override
    public Spliterator<T> trySplit() {
        List<Spliterator<T>> split = this._spliterators.stream().map(Spliterator::trySplit).collect(Collectors.toList());
        return split.stream().noneMatch(Objects::isNull) ? new ConcatSpliterator<T>(split) : null;
    }

    @Override
    public long estimateSize() {
        boolean maxValueSized = this._spliterators.stream().mapToLong(Spliterator::estimateSize).anyMatch(l -> l == Long.MAX_VALUE);
        return maxValueSized ? Long.MAX_VALUE : this._spliterators.stream().mapToLong(Spliterator::estimateSize).min().orElse(1L) * (long)this._spliterators.size();
    }

    @Override
    public int characteristics() {
        return this._spliterators.stream().mapToInt(Spliterator::characteristics).reduce(-1, (i1, i2) -> i1 & i2) & 0xFFFFFFFB;
    }
}

