/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.internal;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;

public final class IntList {
    private static final int MAX_SIZE = 0x7FFFFFF7;
    private static final int DEFAULT_CAPACITY = 10;
    private static final int[] EMPTY_ARRAY = new int[0];
    private static final int[] DEFAULT_EMPTY_ARRAY = new int[0];
    private int[] _data;
    private int _size;

    public IntList(int capacity) {
        if (capacity > 0) {
            this._data = new int[capacity];
        } else if (capacity == 0) {
            this._data = EMPTY_ARRAY;
        } else {
            throw new IllegalArgumentException("Illegal Capacity: " + capacity);
        }
    }

    public IntList() {
        this._data = DEFAULT_EMPTY_ARRAY;
    }

    public int get(int index) {
        this.rangeCheck(index);
        return this._data[index];
    }

    public void forEach(IntConsumer action) {
        Objects.requireNonNull(action);
        int size = this._size;
        for (int i = 0; i < size; ++i) {
            action.accept(this._data[i]);
        }
    }

    public IntStream stream() {
        return Arrays.stream(this._data, 0, this._size);
    }

    public void add(int element) {
        this.ensureSize(this._size + 1);
        this._data[this._size++] = element;
    }

    public void add(int index, int element) {
        this.addRangeCheck(index);
        this.ensureSize(this._size + 1);
        System.arraycopy(this._data, index, this._data, index + 1, this._size - index);
        this._data[index] = element;
        ++this._size;
    }

    public boolean addAll(int[] elements) {
        int count = elements.length;
        this.ensureSize(this._size + count);
        System.arraycopy(elements, 0, this._data, this._size, count);
        this._size += count;
        return count != 0;
    }

    public boolean addAll(int index, int[] elements) {
        this.addRangeCheck(index);
        int count = elements.length;
        this.ensureSize(this._size + count);
        int moved = this._size - index;
        if (moved > 0) {
            System.arraycopy(this._data, index, this._data, index + count, moved);
        }
        System.arraycopy(elements, 0, this._data, index, count);
        this._size += count;
        return count != 0;
    }

    public void clear() {
        this._size = 0;
    }

    public void trimToSize() {
        if (this._size < this._data.length) {
            this._data = this._size == 0 ? EMPTY_ARRAY : Arrays.copyOf(this._data, this._size);
        }
    }

    public int size() {
        return this._size;
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public int[] toArray() {
        return Arrays.copyOf(this._data, this._size);
    }

    private void ensureSize(int size) {
        this.ensureExplicitSize(IntList.capacity(this._data, size));
    }

    private void ensureExplicitSize(int size) {
        if (size - this._data.length > 0) {
            this.grow(size);
        }
    }

    private void rangeCheck(int index) {
        if (index >= this._size) {
            throw new IndexOutOfBoundsException(String.format("Index: %d, Size: %d", index, this._size));
        }
    }

    private void addRangeCheck(int index) {
        if (index > this._size || index < 0) {
            throw new IndexOutOfBoundsException(String.format("Index: %d, Size: %d", index, this._size));
        }
    }

    private static int capacity(int[] data, int capacity) {
        if (data == DEFAULT_EMPTY_ARRAY) {
            return Math.max(10, capacity);
        }
        return capacity;
    }

    private void grow(int size) {
        int oldSize = this._data.length;
        int newSize = oldSize + (oldSize >> 1);
        if (newSize - size < 0) {
            newSize = size;
        }
        if (newSize - 0x7FFFFFF7 > 0) {
            newSize = IntList.hugeCapacity(size);
        }
        this._data = Arrays.copyOf(this._data, newSize);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }
}

