/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.moea;

import io.jenetics.Gene;
import io.jenetics.Optimize;
import io.jenetics.Phenotype;
import io.jenetics.engine.EvolutionResult;
import io.jenetics.ext.moea.ElementComparator;
import io.jenetics.ext.moea.ElementDistance;
import io.jenetics.ext.moea.Pareto;
import io.jenetics.ext.moea.ParetoFront;
import io.jenetics.ext.moea.Vec;
import io.jenetics.util.ISeq;
import io.jenetics.util.IntRange;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.stream.Collector;

public final class MOEA {
    private static final IntRange DEFAULT_SET_RANGE = IntRange.of((int)75, (int)100);

    private MOEA() {
    }

    public static <G extends Gene<?, G>, T, V extends Vec<T>> Collector<EvolutionResult<G, V>, ?, ISeq<Phenotype<G, V>>> toParetoSet() {
        return MOEA.toParetoSet(DEFAULT_SET_RANGE);
    }

    public static <G extends Gene<?, G>, T, V extends Vec<T>> Collector<EvolutionResult<G, V>, ?, ISeq<Phenotype<G, V>>> toParetoSet(IntRange size) {
        return MOEA.toParetoSet(size, Vec::dominance, Vec::compare, Vec::distance, Vec::length);
    }

    public static <G extends Gene<?, G>, C extends Comparable<? super C>> Collector<EvolutionResult<G, C>, ?, ISeq<Phenotype<G, C>>> toParetoSet(IntRange size, Comparator<? super C> dominance, ElementComparator<? super C> comparator, ElementDistance<? super C> distance, ToIntFunction<? super C> dimension) {
        Objects.requireNonNull(size);
        Objects.requireNonNull(dominance);
        Objects.requireNonNull(distance);
        if (size.getMin() < 1) {
            throw new IllegalArgumentException(String.format("Minimal pareto set size must be greater than zero: %d", size.getMin()));
        }
        return Collector.of(() -> new Front(size, dominance, comparator, distance, dimension), Front::add, Front::merge, Front::toISeq, new Collector.Characteristics[0]);
    }

    private static final class Front<G extends Gene<?, G>, C extends Comparable<? super C>> {
        final IntRange _size;
        final Comparator<? super C> _dominance;
        final ElementComparator<? super C> _comparator;
        final ElementDistance<? super C> _distance;
        final ToIntFunction<? super C> _dimension;
        private Optimize _optimize;
        private ParetoFront<Phenotype<G, C>> _front;

        Front(IntRange size, Comparator<? super C> dominance, ElementComparator<? super C> comparator, ElementDistance<? super C> distance, ToIntFunction<? super C> dimension) {
            this._size = size;
            this._dominance = dominance;
            this._comparator = comparator;
            this._distance = distance;
            this._dimension = dimension;
        }

        void add(EvolutionResult<G, C> result) {
            if (this._front == null) {
                this._optimize = result.getOptimize();
                this._front = new ParetoFront<Phenotype>(this::dominance, this::equals);
            }
            ISeq front = Pareto.front(result.getPopulation(), this::dominance);
            this._front.addAll(front.asList());
            this.trim();
        }

        private int dominance(Phenotype<G, C> a, Phenotype<G, C> b) {
            return this._optimize == Optimize.MAXIMUM ? this._dominance.compare(a.getFitness(), b.getFitness()) : this._dominance.compare(b.getFitness(), a.getFitness());
        }

        private boolean equals(Phenotype<?, ?> a, Phenotype<?, ?> b) {
            return Objects.equals(a.getGenotype(), b.getGenotype());
        }

        private void trim() {
            assert (this._front != null);
            assert (this._optimize != null);
            if (this._front.size() > this._size.getMax() - 1) {
                this._front.trim(this._size.getMin(), this::compare, this._distance.map(Phenotype::getFitness), v -> this._dimension.applyAsInt(v.getFitness()));
            }
        }

        private int compare(Phenotype<G, C> a, Phenotype<G, C> b, int i) {
            return this._optimize == Optimize.MAXIMUM ? this._comparator.compare(a.getFitness(), b.getFitness(), i) : this._comparator.compare(b.getFitness(), a.getFitness(), i);
        }

        Front<G, C> merge(Front<G, C> front) {
            this._front.merge(front._front);
            this.trim();
            return this;
        }

        ISeq<Phenotype<G, C>> toISeq() {
            return this._front != null ? this._front.toISeq() : ISeq.empty();
        }
    }
}

