/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.moea;

import io.jenetics.Gene;
import io.jenetics.Optimize;
import io.jenetics.Phenotype;
import io.jenetics.Selector;
import io.jenetics.ext.moea.CrowdedComparator;
import io.jenetics.ext.moea.ElementComparator;
import io.jenetics.ext.moea.ElementDistance;
import io.jenetics.ext.moea.Vec;
import io.jenetics.util.ISeq;
import io.jenetics.util.ProxySorter;
import io.jenetics.util.Seq;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;

public class NSGA2Selector<G extends Gene<?, G>, C extends Comparable<? super C>>
implements Selector<G, C> {
    private final Comparator<Phenotype<G, C>> _dominance;
    private final ElementComparator<Phenotype<G, C>> _comparator;
    private final ElementDistance<Phenotype<G, C>> _distance;
    private final ToIntFunction<Phenotype<G, C>> _dimension;

    public NSGA2Selector(Comparator<? super C> dominance, ElementComparator<? super C> comparator, ElementDistance<? super C> distance, ToIntFunction<? super C> dimension) {
        Objects.requireNonNull(dominance);
        Objects.requireNonNull(comparator);
        Objects.requireNonNull(distance);
        Objects.requireNonNull(dimension);
        this._dominance = (a, b) -> dominance.compare((Object)a.getFitness(), (Object)b.getFitness());
        this._comparator = comparator.map(Phenotype::getFitness);
        this._distance = distance.map(Phenotype::getFitness);
        this._dimension = v -> dimension.applyAsInt((Object)v.getFitness());
    }

    public ISeq<Phenotype<G, C>> select(Seq<Phenotype<G, C>> population, int count, Optimize opt) {
        CrowdedComparator cc = new CrowdedComparator(population, opt, this._dominance, this._comparator, this._distance, this._dimension);
        int[] idx = ProxySorter.sort((Object)NSGA2Selector.init(new int[population.size()]), (int)population.size(), (a, i, j) -> cc.compare(a[j], a[i]));
        ArrayList result = new ArrayList();
        while (result.size() < count) {
            IntStream.of(idx).limit(count - result.size()).mapToObj(population).forEach(result::add);
        }
        return ISeq.of(result);
    }

    private static int[] init(int[] indexes) {
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = i;
        }
        return indexes;
    }

    public static <G extends Gene<?, G>, T, V extends Vec<T>> NSGA2Selector<G, V> ofVec() {
        return new NSGA2Selector<G, Vec>(Vec::dominance, Vec::compare, Vec::distance, Vec::length);
    }
}

