/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.moea;

import io.jenetics.ext.moea.ElementComparator;
import io.jenetics.ext.moea.ElementDistance;
import io.jenetics.ext.moea.Vec;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;

final class Vecs {
    private Vecs() {
    }

    private static void checkVecLength(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Array length must greater zero.");
        }
    }

    static final class DoubleVec
    implements Vec<double[]>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final double[] _data;

        DoubleVec(double[] data) {
            Vecs.checkVecLength(data.length);
            this._data = data;
        }

        @Override
        public double[] data() {
            return this._data;
        }

        @Override
        public int length() {
            return this._data.length;
        }

        @Override
        public ElementComparator<double[]> comparator() {
            return (u, v, i) -> Double.compare(u[i], v[i]);
        }

        @Override
        public ElementDistance<double[]> distance() {
            return (u, v, i) -> u[i] - v[i];
        }

        @Override
        public Comparator<double[]> dominance() {
            return Vec::dominance;
        }

        public int hashCode() {
            return Arrays.hashCode(this._data);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof DoubleVec && Arrays.equals(((DoubleVec)obj)._data, this._data);
        }

        public String toString() {
            return Arrays.toString(this._data);
        }
    }

    static final class LongVec
    implements Vec<long[]>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final long[] _data;

        LongVec(long[] data) {
            Vecs.checkVecLength(data.length);
            this._data = data;
        }

        @Override
        public long[] data() {
            return this._data;
        }

        @Override
        public int length() {
            return this._data.length;
        }

        @Override
        public ElementComparator<long[]> comparator() {
            return (u, v, i) -> Long.compare(u[i], v[i]);
        }

        @Override
        public ElementDistance<long[]> distance() {
            return (u, v, i) -> u[i] - v[i];
        }

        @Override
        public Comparator<long[]> dominance() {
            return Vec::dominance;
        }

        public int hashCode() {
            return Arrays.hashCode(this._data);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof LongVec && Arrays.equals(((LongVec)obj)._data, this._data);
        }

        public String toString() {
            return Arrays.toString(this._data);
        }
    }

    static final class IntVec
    implements Vec<int[]>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final int[] _data;

        IntVec(int[] data) {
            Vecs.checkVecLength(data.length);
            this._data = data;
        }

        @Override
        public int[] data() {
            return this._data;
        }

        @Override
        public int length() {
            return this._data.length;
        }

        @Override
        public ElementComparator<int[]> comparator() {
            return (u, v, i) -> Integer.compare(u[i], v[i]);
        }

        @Override
        public ElementDistance<int[]> distance() {
            return (u, v, i) -> u[i] - v[i];
        }

        @Override
        public Comparator<int[]> dominance() {
            return Vec::dominance;
        }

        public int hashCode() {
            return Arrays.hashCode(this._data);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof IntVec && Arrays.equals(((IntVec)obj)._data, this._data);
        }

        public String toString() {
            return Arrays.toString(this._data);
        }
    }

    static final class ObjectVec<T>
    implements Vec<T[]> {
        private final T[] _data;
        private final Comparator<? super T> _comparator;
        private final ElementDistance<T[]> _distance;

        ObjectVec(T[] data, Comparator<? super T> comparator, ElementDistance<T[]> distance) {
            Vecs.checkVecLength(data.length);
            this._data = data;
            this._comparator = Objects.requireNonNull(comparator);
            this._distance = Objects.requireNonNull(distance);
        }

        @Override
        public T[] data() {
            return this._data;
        }

        @Override
        public int length() {
            return this._data.length;
        }

        @Override
        public ElementComparator<T[]> comparator() {
            return (u, v, i) -> this._comparator.compare(u[i], v[i]);
        }

        @Override
        public ElementDistance<T[]> distance() {
            return this._distance;
        }

        @Override
        public Comparator<T[]> dominance() {
            return (u, v) -> Vec.dominance(u, v, this._comparator);
        }

        public int hashCode() {
            return Arrays.hashCode(this._data);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof ObjectVec && Arrays.equals(((ObjectVec)obj)._data, this._data);
        }

        public String toString() {
            return Arrays.toString(this._data);
        }
    }
}

