/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.rewriting;

import io.jenetics.ext.rewriting.TreePattern;
import io.jenetics.ext.util.Tree;
import io.jenetics.internal.util.Hashes;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public final class TreeMatchResult<V> {
    private final Tree<V, ?> _tree;
    private final Map<TreePattern.Var<V>, Tree<V, ?>> _vars;

    private TreeMatchResult(Tree<V, ?> tree, Map<TreePattern.Var<V>, Tree<V, ?>> vars) {
        this._tree = Objects.requireNonNull(tree);
        this._vars = Collections.unmodifiableMap(Objects.requireNonNull(vars));
    }

    public Tree<V, ?> tree() {
        return this._tree;
    }

    public Map<TreePattern.Var<V>, Tree<V, ?>> vars() {
        return this._vars;
    }

    public int hashCode() {
        return Hashes.hash(this._tree, (int)Hashes.hash(this._vars));
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof TreeMatchResult && this._tree.equals(((TreeMatchResult)obj)._tree) && this._vars.equals(((TreeMatchResult)obj)._vars);
    }

    public String toString() {
        return this._tree.toParenthesesString();
    }

    static <V> TreeMatchResult<V> of(Tree<V, ?> tree, Map<TreePattern.Var<V>, Tree<V, ?>> vars) {
        return new TreeMatchResult<V>(tree, vars);
    }
}

