/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.rewriting;

import io.jenetics.ext.internal.Escaper;
import io.jenetics.ext.internal.Names;
import io.jenetics.ext.rewriting.Serial;
import io.jenetics.ext.rewriting.TreeMatchResult;
import io.jenetics.ext.rewriting.TreeMatcher;
import io.jenetics.ext.util.Tree;
import io.jenetics.ext.util.TreeNode;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class TreePattern<V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final TreeNode<Decl<V>> _pattern;
    private final SortedSet<Var<V>> _vars;

    public TreePattern(Tree<Decl<V>, ?> pattern) {
        this._pattern = TreeNode.ofTree(pattern);
        this._vars = TreePattern.extractVars(this._pattern);
    }

    private static <V> SortedSet<Var<V>> extractVars(TreeNode<Decl<V>> pattern) {
        TreeSet<Var> variables = new TreeSet<Var>();
        for (Tree tree : pattern) {
            if (!(tree.getValue() instanceof Var)) continue;
            if (!tree.isLeaf()) {
                throw new IllegalArgumentException(String.format("Variable node '%s' is not a leaf: %s", tree.getValue(), tree.toParenthesesString()));
            }
            variables.add((Var)tree.getValue());
        }
        return Collections.unmodifiableSortedSet(variables);
    }

    TreeNode<Decl<V>> pattern() {
        return this._pattern;
    }

    public SortedSet<Var<V>> vars() {
        return this._vars;
    }

    public <B> TreePattern<B> map(Function<? super V, ? extends B> mapper) {
        return new TreePattern<V>(this._pattern.map((? super T d) -> d.map(mapper)));
    }

    public TreeMatcher<V> matcher(Tree<V, ?> tree) {
        return TreeMatcher.of(this, tree);
    }

    public Optional<TreeMatchResult<V>> match(Tree<V, ?> tree) {
        HashMap vars = new HashMap();
        boolean matches = TreePattern.matches(tree, this._pattern, vars);
        return matches ? Optional.of(TreeMatchResult.of(tree, vars)) : Optional.empty();
    }

    public boolean matches(Tree<V, ?> tree) {
        return TreePattern.matches(tree, this._pattern, new HashMap());
    }

    private static <V> boolean matches(Tree<V, ?> node, Tree<Decl<V>, ?> pattern, Map<Var<V>, Tree<V, ?>> vars) {
        Decl<V> decl = pattern.getValue();
        if (decl instanceof Var) {
            Tree<V, ?> tree = vars.get(decl);
            if (tree == null) {
                vars.put((Var)decl, node);
                return true;
            }
            return tree.equals(node);
        }
        Val p = (Val)pattern.getValue();
        V v = node.getValue();
        if (Objects.equals(v, p.value())) {
            if (node.childCount() == pattern.childCount()) {
                for (int i = 0; i < node.childCount(); ++i) {
                    Object cp;
                    Object cn = node.childAt(i);
                    if (TreePattern.matches(cn, cp = pattern.childAt(i), vars)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public TreeNode<V> expand(Map<Var<V>, Tree<V, ?>> vars) {
        return TreePattern.expand(this._pattern, vars);
    }

    private static <V> TreeNode<V> expand(Tree<Decl<V>, ?> template, Map<Var<V>, Tree<V, ?>> vars) {
        Map<Tree.Path, Var> paths = template.stream().filter(n -> n.getValue() instanceof Var).collect(Collectors.toMap(t -> t.childPath(), t -> (Var)t.getValue()));
        TreeNode<Object> tree = TreeNode.ofTree(template, n -> n instanceof Val ? ((Val)n).value() : null);
        for (Map.Entry<Tree.Path, Var> var : paths.entrySet()) {
            Tree.Path path = var.getKey();
            Var decl = var.getValue();
            Tree<V, ?> replacement = vars.get(decl);
            if (replacement != null) {
                tree.replaceAtPath(path, TreeNode.ofTree(replacement));
                continue;
            }
            tree.removeAtPath(path);
        }
        return tree;
    }

    public int hashCode() {
        return this._pattern.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof TreePattern && this._pattern.equals(((TreePattern)obj)._pattern);
    }

    public String toString() {
        return this._pattern.toParenthesesString();
    }

    public static TreePattern<String> compile(String pattern) {
        return TreePattern.compile(pattern, Function.identity());
    }

    public static <V> TreePattern<V> compile(String pattern, Function<? super String, ? extends V> mapper) {
        return new TreePattern<V>(TreeNode.parse(pattern, v -> Decl.of(v.trim(), mapper)));
    }

    private Object writeReplace() {
        return new Serial(1, this);
    }

    private void readObject(ObjectOutputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(ObjectOutput out) throws IOException {
        out.writeObject(this._pattern);
    }

    static TreePattern read(ObjectInput in) throws IOException, ClassNotFoundException {
        TreeNode pattern = (TreeNode)in.readObject();
        return new TreePattern(pattern);
    }

    public static final class Val<V>
    extends Decl<V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final V _value;

        private Val(V value) {
            this._value = value;
        }

        public V value() {
            return this._value;
        }

        @Override
        <B> Val<B> map(Function<? super V, ? extends B> mapper) {
            return Val.of(mapper.apply(this._value));
        }

        public int hashCode() {
            return Objects.hashCode(this._value);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Val && Objects.equals(this._value, ((Val)obj)._value);
        }

        public String toString() {
            return Objects.toString(this._value);
        }

        public static <V> Val<V> of(V value) {
            return new Val<V>(value);
        }

        private Object writeReplace() {
            return new Serial(3, this);
        }

        private void readObject(ObjectOutputStream stream) throws InvalidObjectException {
            throw new InvalidObjectException("Serialization proxy required.");
        }

        void write(ObjectOutput out) throws IOException {
            out.writeObject(this._value);
        }

        static Val read(ObjectInput in) throws IOException, ClassNotFoundException {
            return new Val<Object>(in.readObject());
        }
    }

    public static final class Var<V>
    extends Decl<V>
    implements Comparable<Var<V>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String _name;

        private Var(String name) {
            if (!Names.isIdentifier(name)) {
                throw new IllegalArgumentException(String.format("Variable is not valid identifier: '%s'", name));
            }
            this._name = name;
        }

        @Override
        <B> Var<B> map(Function<? super V, ? extends B> mapper) {
            return this;
        }

        public String name() {
            return this._name;
        }

        @Override
        public int compareTo(Var<V> var) {
            return this._name.compareTo(var._name);
        }

        public int hashCode() {
            return this._name.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Var && Objects.equals(this._name, ((Var)obj)._name);
        }

        public String toString() {
            return String.format("%s%s", Character.valueOf('$'), this._name);
        }

        public static <V> Var<V> of(String name) {
            return new Var<V>(name);
        }

        static boolean isVar(String name) {
            return !name.isEmpty() && name.charAt(0) == '$';
        }

        private Object writeReplace() {
            return new Serial(2, this);
        }

        private void readObject(ObjectOutputStream stream) throws InvalidObjectException {
            throw new InvalidObjectException("Serialization proxy required.");
        }

        void write(ObjectOutput out) throws IOException {
            out.writeObject(this._name);
        }

        static Var read(ObjectInput in) throws IOException, ClassNotFoundException {
            String name = (String)in.readObject();
            return new Var(name);
        }
    }

    public static abstract class Decl<V> {
        private static final char VAR_PREFIX = '$';
        private static final char ESC_CHAR = '\\';
        private static final Escaper ESCAPER = new Escaper('\\', '$');

        private Decl() {
        }

        abstract <B> Decl<B> map(Function<? super V, ? extends B> var1);

        static <V> Decl<V> of(String value, Function<? super String, ? extends V> mapper) {
            return Var.isVar(value) ? Var.of(value.substring(1)) : Val.of(mapper.apply(ESCAPER.unescape(value)));
        }
    }
}

