/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.util;

import io.jenetics.ext.util.FlatTree;
import io.jenetics.ext.util.Serial;
import io.jenetics.ext.util.Tree;
import io.jenetics.ext.util.TreeParser;
import io.jenetics.internal.util.SerialIO;
import io.jenetics.util.ISeq;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class FlatTreeNode<T>
implements FlatTree<T, FlatTreeNode<T>>,
Serializable {
    private static final long serialVersionUID = 3L;
    private final int _index;
    private final Object[] _elements;
    private final int[] _childOffsets;
    private final int[] _childCounts;

    private FlatTreeNode(int index, Object[] elements, int[] childOffsets, int[] childCounts) {
        this._index = index;
        this._elements = Objects.requireNonNull(elements);
        this._childOffsets = Objects.requireNonNull(childOffsets);
        this._childCounts = Objects.requireNonNull(childCounts);
    }

    @Override
    public FlatTreeNode<T> getRoot() {
        return this.nodeAt(0);
    }

    @Override
    public boolean isRoot() {
        return this._index == 0;
    }

    private FlatTreeNode<T> nodeAt(int index) {
        return new FlatTreeNode<T>(index, this._elements, this._childOffsets, this._childCounts);
    }

    @Override
    public T getValue() {
        return (T)this._elements[this._index];
    }

    @Override
    public Optional<FlatTreeNode<T>> getParent() {
        int index = -1;
        int i = this._index;
        while (--i >= 0 && index == -1) {
            if (!this.isParent(i)) continue;
            index = i;
        }
        return index != -1 ? Optional.of(this.nodeAt(index)) : Optional.empty();
    }

    private boolean isParent(int index) {
        return this._childCounts[index] > 0 && this._childOffsets[index] <= this._index && this._childOffsets[index] + this._childCounts[index] > this._index;
    }

    @Override
    public FlatTreeNode<T> childAt(int index) {
        if (index < 0 || index >= this.childCount()) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        return this.nodeAt(this.childOffset() + index);
    }

    @Override
    public int childCount() {
        return this._childCounts[this._index];
    }

    @Override
    public int childOffset() {
        return this._childOffsets[this._index];
    }

    @Override
    public ISeq<FlatTreeNode<T>> flattenedNodes() {
        return (ISeq)this.stream().collect(ISeq.toISeq());
    }

    @Override
    public Stream<FlatTreeNode<T>> stream() {
        return IntStream.range(0, this._elements.length).mapToObj(this::nodeAt);
    }

    public <B> ISeq<B> map(Function<FlatTreeNode<T>, ? extends B> mapper) {
        return (ISeq)this.stream().map(mapper).collect(ISeq.toISeq());
    }

    @Override
    public boolean identical(Tree<?, ?> other) {
        return other == this || other instanceof FlatTreeNode && ((FlatTreeNode)other)._index == this._index && ((FlatTreeNode)other)._elements == this._elements;
    }

    public int hashCode() {
        return Tree.hashCode(this);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof FlatTreeNode && (this.equals((FlatTreeNode)obj) || Tree.equals((Tree)obj, this));
    }

    private boolean equals(FlatTreeNode<?> tree) {
        return tree._index == this._index && Arrays.equals(tree._elements, this._elements) && Arrays.equals(tree._childCounts, this._childCounts) && Arrays.equals(tree._childOffsets, this._childOffsets);
    }

    public String toString() {
        return this.toParenthesesString();
    }

    @Override
    public int size() {
        return this.countChildren(this._index) + 1;
    }

    private int countChildren(int index) {
        int count = this._childCounts[index];
        for (int i = 0; i < this._childCounts[index]; ++i) {
            count += this.countChildren(this._childOffsets[index] + i);
        }
        return count;
    }

    public static <V> FlatTreeNode<V> of(Tree<? extends V, ?> tree) {
        Objects.requireNonNull(tree);
        int size = tree.size();
        assert (size >= 1);
        Object[] elements = new Object[size];
        int[] childOffsets = new int[size];
        int[] childCounts = new int[size];
        int childOffset = 1;
        int index = 0;
        for (Tree node : tree) {
            elements[index] = node.getValue();
            childCounts[index] = node.childCount();
            childOffsets[index] = node.isLeaf() ? -1 : childOffset;
            childOffset += node.childCount();
            ++index;
        }
        return new FlatTreeNode(0, elements, childOffsets, childCounts);
    }

    public static FlatTreeNode<String> parse(String tree) {
        return FlatTreeNode.of(TreeParser.parse(tree, Function.identity()));
    }

    public static <B> FlatTreeNode<B> parse(String tree, Function<? super String, ? extends B> mapper) {
        return FlatTreeNode.of(TreeParser.parse(tree, mapper));
    }

    private Object writeReplace() {
        return new Serial(2, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(ObjectOutput out) throws IOException {
        FlatTreeNode node = this._index == 0 ? this : FlatTreeNode.of(this);
        SerialIO.writeObjectArray((Object[])node._elements, (ObjectOutput)out);
        SerialIO.writeIntArray((int[])node._childOffsets, (DataOutput)out);
        SerialIO.writeIntArray((int[])node._childCounts, (DataOutput)out);
    }

    static FlatTreeNode read(ObjectInput in) throws IOException, ClassNotFoundException {
        return new FlatTreeNode(0, SerialIO.readObjectArray((ObjectInput)in), SerialIO.readIntArray((DataInput)in), SerialIO.readIntArray((DataInput)in));
    }
}

