/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.util;

import io.jenetics.ext.util.ParenthesesTrees;
import io.jenetics.ext.util.Tree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class TreeFormatter {
    public static final TreeFormatter TREE = new TreeFormatter(){

        @Override
        public <V> String format(Tree<V, ?> tree, Function<? super V, String> mapper) {
            Objects.requireNonNull(tree);
            Objects.requireNonNull(mapper);
            return this.toStrings(tree, mapper).stream().map(StringBuilder::toString).collect(Collectors.joining("\n"));
        }

        private <V> List<StringBuilder> toStrings(Tree<V, ?> tree, Function<? super V, String> mapper) {
            ArrayList<StringBuilder> result = new ArrayList<StringBuilder>();
            result.add(new StringBuilder().append(mapper.apply(tree.getValue())));
            Iterator<?> it = tree.childIterator();
            while (it.hasNext()) {
                List<StringBuilder> subtree = this.toStrings((Tree)it.next(), mapper);
                if (it.hasNext()) {
                    this.subtree(result, subtree, mapper);
                    continue;
                }
                this.lastSubtree(result, subtree);
            }
            return result;
        }

        private <V> void subtree(List<StringBuilder> result, List<StringBuilder> subtree, Function<? super V, String> mapper) {
            Iterator<StringBuilder> it = subtree.iterator();
            result.add(it.next().insert(0, "\u251c\u2500\u2500 "));
            while (it.hasNext()) {
                result.add(it.next().insert(0, "\u2502   "));
            }
        }

        private void lastSubtree(List<StringBuilder> result, List<StringBuilder> subtree) {
            Iterator<StringBuilder> it = subtree.iterator();
            result.add(it.next().insert(0, "\u2514\u2500\u2500 "));
            while (it.hasNext()) {
                result.add(it.next().insert(0, "    "));
            }
        }
    };
    public static final TreeFormatter PARENTHESES = new TreeFormatter(){

        @Override
        public <V> String format(Tree<V, ?> tree, Function<? super V, String> mapper) {
            Objects.requireNonNull(tree);
            Objects.requireNonNull(mapper);
            return ParenthesesTrees.toString(tree, mapper);
        }
    };
    public static final TreeFormatter LISP = new TreeFormatter(){

        @Override
        public <V> String format(Tree<V, ?> tree, Function<? super V, String> mapper) {
            String value = mapper.apply(tree.getValue());
            if (tree.isLeaf()) {
                return value;
            }
            String children = tree.childStream().map(child -> this.format((Tree)child, mapper)).collect(Collectors.joining(" "));
            return "(" + value + " " + children + ")";
        }
    };
    public static final TreeFormatter DOT = TreeFormatter.dot("Tree");

    protected TreeFormatter() {
    }

    public abstract <V> String format(Tree<V, ?> var1, Function<? super V, String> var2);

    public String format(Tree<?, ?> tree) {
        return this.format(tree, Objects::toString);
    }

    public static TreeFormatter dot(String treeName) {
        return new Dotty(treeName);
    }

    private static final class Dotty
    extends TreeFormatter {
        private final String _name;

        Dotty(String name) {
            this._name = Objects.requireNonNull(name);
        }

        @Override
        public <V> String format(Tree<V, ?> tree, Function<? super V, String> mapper) {
            return new Helper<V>(this._name, tree, mapper).draw();
        }

        private static final class Helper<V> {
            private final String _name;
            private final Function<? super V, String> _mapper;
            private final Map<String, String> _labels = new HashMap<String, String>();
            private final List<String> _edges = new ArrayList<String>();

            Helper(String name, Tree<V, ?> tree, Function<? super V, String> mapper) {
                this._name = Objects.requireNonNull(name);
                this._mapper = Objects.requireNonNull(mapper);
                this.init(tree, null, 0);
            }

            private int init(Tree<V, ?> tree, String parentLabel, int index) {
                int idx = index;
                String value = this._mapper.apply(tree.getValue());
                String label = String.format("node_%03d", idx);
                this._labels.put(label, value);
                if (parentLabel != null) {
                    this._edges.add(parentLabel + " -> " + label);
                }
                for (int i = 0; i < tree.childCount(); ++i) {
                    Object child = tree.childAt(i);
                    idx = this.init((Tree<V, ?>)child, label, idx + 1);
                }
                return idx;
            }

            String draw() {
                StringBuilder builder = new StringBuilder();
                builder.append("digraph ").append(this._name).append(" {\n");
                this._labels.forEach((key, value) -> builder.append("    ").append((String)key).append(" [label=\"").append(value.replace("\"", "\\\"")).append("\"];\n"));
                this._edges.forEach(edge -> builder.append("    ").append((String)edge).append(";\n"));
                builder.append("}\n");
                return builder.toString();
            }
        }
    }
}

