/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.util;

import io.jenetics.ext.util.FlatTreeNode;
import io.jenetics.ext.util.Serial;
import io.jenetics.ext.util.Tree;
import io.jenetics.ext.util.TreeParser;
import io.jenetics.util.Copyable;
import io.jenetics.util.ISeq;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public final class TreeNode<T>
implements Tree<T, TreeNode<T>>,
Iterable<TreeNode<T>>,
Copyable<TreeNode<T>>,
Serializable {
    private static final long serialVersionUID = 2L;
    private T _value;
    private TreeNode<T> _parent;
    private List<TreeNode<T>> _children;

    private TreeNode(T value) {
        this._value = value;
    }

    public void setValue(T value) {
        this._value = value;
    }

    @Override
    public T getValue() {
        return this._value;
    }

    @Override
    public Optional<TreeNode<T>> getParent() {
        return Optional.ofNullable(this._parent);
    }

    void setParent(TreeNode<T> parent) {
        this._parent = parent;
    }

    @Override
    public TreeNode<T> childAt(int index) {
        if (this._children == null) {
            throw new ArrayIndexOutOfBoundsException(String.format("Child index is out of bounds: %s", index));
        }
        return this._children.get(index);
    }

    @Override
    public int childCount() {
        return this._children != null ? this._children.size() : 0;
    }

    public TreeNode<T> insert(int index, TreeNode<T> child) {
        Objects.requireNonNull(child);
        if (this.isAncestor(child)) {
            throw new IllegalArgumentException("The new child is an ancestor.");
        }
        if (child._parent != null) {
            child._parent.remove(child);
        }
        child.setParent(this);
        this.createChildrenIfMissing();
        this._children.add(index, child);
        return this;
    }

    private void createChildrenIfMissing() {
        if (this._children == null) {
            this._children = new ArrayList<TreeNode<T>>(2);
        }
    }

    public TreeNode<T> replace(int index, TreeNode<T> child) {
        Objects.requireNonNull(child);
        if (this._children == null) {
            throw new ArrayIndexOutOfBoundsException(String.format("Child index is out of bounds: %s", index));
        }
        if (this.isAncestor(child)) {
            throw new IllegalArgumentException("The new child is an ancestor.");
        }
        TreeNode<T> oldChild = this._children.set(index, child);
        assert (oldChild != null);
        assert (oldChild._parent == this);
        oldChild.setParent(null);
        child.setParent(this);
        return this;
    }

    public TreeNode<T> remove(int index) {
        if (this._children == null) {
            throw new ArrayIndexOutOfBoundsException(String.format("Child index is out of bounds: %s", index));
        }
        TreeNode<T> child = this._children.remove(index);
        assert (child._parent == this);
        child.setParent(null);
        if (this._children.isEmpty()) {
            this._children = null;
        }
        return this;
    }

    public boolean removeAtPath(Tree.Path path) {
        Optional parent = this.childAtPath(path).flatMap(Tree::getParent);
        parent.ifPresent(p -> p.remove(path.get(path.length() - 1)));
        return parent.isPresent();
    }

    public boolean replaceAtPath(Tree.Path path, TreeNode<T> child) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(child);
        Optional<TreeNode> old = this.childAtPath(path);
        Optional parent = old.flatMap(TreeNode::getParent);
        if (parent.isPresent()) {
            ((TreeNode)parent.orElseThrow(AssertionError::new)).replace(path.get(path.length() - 1), child);
        } else {
            this.removeAllChildren();
            this.setValue(child.getValue());
            ISeq nodes = (ISeq)child.childStream().collect(ISeq.toISeq());
            for (TreeNode node : nodes) {
                this.attach((T)node);
            }
        }
        return old.isPresent();
    }

    public TreeNode<T> detach() {
        if (this._parent != null) {
            this._parent.remove(this);
        }
        return this;
    }

    public void remove(Tree<?, ?> child) {
        Objects.requireNonNull(child);
        if (!this.isChild(child)) {
            throw new IllegalArgumentException("The given child is not a child.");
        }
        this.remove(this.indexOf(child));
    }

    public void removeAllChildren() {
        int n = this.childCount();
        for (int i = 0; i < n; ++i) {
            this.remove(this._children.size() - 1);
        }
    }

    public TreeNode<T> attach(TreeNode<T> child) {
        Objects.requireNonNull(child);
        if (child._parent == this) {
            this.insert(this.childCount() - 1, child);
        } else {
            this.insert(this.childCount(), child);
        }
        return this;
    }

    @SafeVarargs
    public final TreeNode<T> attach(T ... children) {
        for (T child : children) {
            this.attach((T)TreeNode.of(child));
        }
        return this;
    }

    public TreeNode<T> attach(T child) {
        return this.attach((T)TreeNode.of(child));
    }

    public TreeNode<T> copy() {
        return TreeNode.ofTree(this);
    }

    public <B> TreeNode<B> map(Function<? super T, ? extends B> mapper) {
        TreeNode<B> target = TreeNode.of(mapper.apply(this.getValue()));
        TreeNode.fill(this, target, mapper);
        return target;
    }

    public int hashCode() {
        return Tree.hashCode(this);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof TreeNode && Tree.equals(this, (TreeNode)obj);
    }

    public String toString() {
        return this.toParenthesesString();
    }

    public static <T> TreeNode<T> of() {
        return TreeNode.of(null);
    }

    public static <T> TreeNode<T> of(T value) {
        return new TreeNode<T>(value);
    }

    public static <T, B> TreeNode<B> ofTree(Tree<? extends T, ?> tree, Function<? super T, ? extends B> mapper) {
        TreeNode<B> target = TreeNode.of(mapper.apply(tree.getValue()));
        TreeNode.fill(tree, target, mapper);
        return target;
    }

    private static <T, B> void fill(Tree<? extends T, ?> source, TreeNode<B> target, Function<? super T, ? extends B> mapper) {
        source.childStream().forEachOrdered(child -> {
            TreeNode targetChild = TreeNode.of(mapper.apply((Object)child.getValue()));
            target.attach((T)targetChild);
            TreeNode.fill(child, targetChild, mapper);
        });
    }

    public static <T> TreeNode<T> ofTree(Tree<? extends T, ?> tree) {
        return TreeNode.ofTree(tree, Function.identity());
    }

    public static TreeNode<String> parse(String tree) {
        return TreeParser.parse(tree, Function.identity());
    }

    public static <B> TreeNode<B> parse(String tree, Function<? super String, ? extends B> mapper) {
        return TreeParser.parse(tree, mapper);
    }

    private Object writeReplace() {
        return new Serial(1, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(ObjectOutput out) throws IOException {
        FlatTreeNode.of(this).write(out);
    }

    static TreeNode read(ObjectInput in) throws IOException, ClassNotFoundException {
        return TreeNode.ofTree(FlatTreeNode.read(in));
    }
}

