/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.util;

import io.jenetics.ext.util.Tree;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Objects;

final class TreeNodePreorderIterator<V, T extends Tree<V, T>>
implements Iterator<T> {
    private final Deque<Iterator<T>> _deque = new LinkedList<Iterator<T>>();

    TreeNodePreorderIterator(T root) {
        Objects.requireNonNull(root);
        this._deque.push(Collections.singletonList(root).iterator());
    }

    @Override
    public boolean hasNext() {
        Iterator<T> peek = this._deque.peek();
        return peek != null && peek.hasNext();
    }

    @Override
    public T next() {
        Iterator children;
        Iterator<T> it = this._deque.peek();
        if (it == null) {
            throw new NoSuchElementException("No next element.");
        }
        Tree node = (Tree)it.next();
        if (!it.hasNext()) {
            this._deque.pop();
        }
        if ((children = node.childIterator()).hasNext()) {
            this._deque.push(children);
        }
        return (T)node;
    }
}

