/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.util;

import io.jenetics.ext.util.Tree;
import io.jenetics.util.MSeq;
import java.util.Iterator;
import java.util.Objects;

final class Trees {
    private Trees() {
    }

    static <V, T extends Tree<V, T>> T self(Tree<?, ?> tree) {
        return (T)tree;
    }

    static <V, T extends Tree<V, T>> MSeq<T> pathElementsFromRoot(T node, int depth) {
        MSeq<Tree> path;
        if (node == null) {
            path = MSeq.ofLength((int)depth);
        } else {
            path = Trees.pathElementsFromRoot(node.getParent().orElse(null), depth + 1);
            path.set(path.length() - depth - 1, node);
        }
        return path;
    }

    static <V, T extends Tree<V, T>> int[] pathFromRoot(T node, int depth) {
        int[] path;
        if (node == null) {
            path = new int[depth - 1];
        } else {
            Tree parent = node.getParent().orElse(null);
            path = Trees.pathFromRoot(parent, depth + 1);
            if (parent != null) {
                int index;
                path[path.length - depth - 1] = index = node.getParent().map(p -> p.indexOf(node)).orElseThrow(AssertionError::new).intValue();
            }
        }
        return path;
    }

    static boolean equals(Tree<?, ?> a, Tree<?, ?> b) {
        boolean equals;
        boolean bl = equals = a == b;
        if (!equals && a != null && b != null) {
            boolean bl2 = equals = a.childCount() == b.childCount();
            if (equals && (equals = Objects.equals(a.getValue(), b.getValue())) && a.childCount() > 0) {
                equals = Trees.equals(a.childIterator(), b.childIterator());
            }
        }
        return equals;
    }

    private static boolean equals(Iterator<? extends Tree<?, ?>> a, Iterator<? extends Tree<?, ?>> b) {
        boolean equals = true;
        while (a.hasNext() && equals) {
            equals = Trees.equals(a.next(), b.next());
        }
        return equals;
    }

    static int countChildren(Tree<?, ?> tree) {
        int cnt = tree.childCount();
        for (int i = 0; i < tree.childCount(); ++i) {
            cnt += Trees.countChildren(tree.childAt(i));
        }
        return cnt;
    }
}

