/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext;

import io.jenetics.AbstractChromosome;
import io.jenetics.NumericChromosome;
import io.jenetics.ext.BigIntegerGene;
import io.jenetics.ext.Serial;
import io.jenetics.internal.util.SerialIO;
import io.jenetics.util.ISeq;
import io.jenetics.util.MSeq;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigInteger;

public class BigIntegerChromosome
extends AbstractChromosome<BigIntegerGene>
implements NumericChromosome<BigInteger, BigIntegerGene>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final BigInteger _min;
    private final BigInteger _max;

    protected BigIntegerChromosome(ISeq<BigIntegerGene> genes) {
        super(genes);
        this._min = (BigInteger)((BigIntegerGene)genes.get(0)).min();
        this._max = (BigInteger)((BigIntegerGene)genes.get(0)).max();
    }

    public BigIntegerChromosome(BigInteger min, BigInteger max, int length) {
        this(BigIntegerGene.seq(min, max, length));
        this._valid = true;
    }

    public BigIntegerChromosome(BigInteger min, BigInteger max) {
        this(min, max, 1);
    }

    public BigInteger min() {
        return this._min;
    }

    public BigInteger max() {
        return this._max;
    }

    public BigIntegerChromosome newInstance(ISeq<BigIntegerGene> genes) {
        return new BigIntegerChromosome(genes);
    }

    public BigIntegerChromosome newInstance() {
        return new BigIntegerChromosome(this._min, this._max, this.length());
    }

    public static BigIntegerChromosome of(BigIntegerGene ... genes) {
        return new BigIntegerChromosome((ISeq<BigIntegerGene>)ISeq.of((Object[])genes));
    }

    public static BigIntegerChromosome of(BigInteger min, BigInteger max, int length) {
        return new BigIntegerChromosome(min, max, length);
    }

    public static BigIntegerChromosome of(BigInteger min, BigInteger max) {
        return new BigIntegerChromosome(min, max);
    }

    private Object writeReplace() {
        return new Serial(1, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(DataOutput out) throws IOException {
        SerialIO.writeInt((int)this.length(), (DataOutput)out);
        SerialIO.writeBytes((byte[])this._min.toByteArray(), (DataOutput)out);
        SerialIO.writeBytes((byte[])this._max.toByteArray(), (DataOutput)out);
        for (BigIntegerGene gene : this._genes) {
            SerialIO.writeBytes((byte[])((BigInteger)gene.allele()).toByteArray(), (DataOutput)out);
        }
    }

    static BigIntegerChromosome read(DataInput in) throws IOException {
        int length = SerialIO.readInt((DataInput)in);
        BigInteger min = new BigInteger(SerialIO.readBytes((DataInput)in));
        BigInteger max = new BigInteger(SerialIO.readBytes((DataInput)in));
        MSeq genes = MSeq.ofLength((int)length);
        for (int i = 0; i < length; ++i) {
            BigInteger value = new BigInteger(SerialIO.readBytes((DataInput)in));
            genes.set(i, (Object)BigIntegerGene.of(value, min, max));
        }
        return new BigIntegerChromosome((ISeq<BigIntegerGene>)genes.toISeq());
    }
}

