/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext;

import io.jenetics.NumericGene;
import io.jenetics.ext.internal.random;
import io.jenetics.internal.util.Hashes;
import io.jenetics.internal.util.Requires;
import io.jenetics.util.ISeq;
import io.jenetics.util.MSeq;
import io.jenetics.util.Mean;
import io.jenetics.util.RandomRegistry;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Random;

public final class BigIntegerGene
implements NumericGene<BigInteger, BigIntegerGene>,
Mean<BigIntegerGene>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private final BigInteger _value;
    private final BigInteger _min;
    private final BigInteger _max;

    private BigIntegerGene(BigInteger value, BigInteger min, BigInteger max) {
        this._value = Objects.requireNonNull(value);
        this._min = Objects.requireNonNull(min);
        this._max = Objects.requireNonNull(max);
    }

    @Deprecated
    public BigInteger getAllele() {
        return this._value;
    }

    @Deprecated
    public BigInteger getMin() {
        return this._min;
    }

    @Deprecated
    public BigInteger getMax() {
        return this._max;
    }

    public BigIntegerGene mean(BigIntegerGene that) {
        BigInteger value = this._value.add(that._value).divide(TWO);
        return BigIntegerGene.of(value, this._min, this._max);
    }

    public BigIntegerGene newInstance(Number number) {
        return BigIntegerGene.of(BigInteger.valueOf(number.longValue()), this._min, this._max);
    }

    public BigIntegerGene newInstance(BigInteger value) {
        return BigIntegerGene.of(value, this._min, this._max);
    }

    public BigIntegerGene newInstance() {
        return BigIntegerGene.of(this._min, this._max);
    }

    public int hashCode() {
        return Hashes.hash((Object)this._value, (int)Hashes.hash((Object)this._min, (int)Hashes.hash((Object)this._max, (int)Hashes.hash(this.getClass()))));
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof BigIntegerGene && Objects.equals(((BigIntegerGene)obj)._value, this._value) && Objects.equals(((BigIntegerGene)obj)._min, this._min) && Objects.equals(((BigIntegerGene)obj)._max, this._max);
    }

    public String toString() {
        return String.format("[%s]", this._value);
    }

    static ISeq<BigIntegerGene> seq(BigInteger minimum, BigInteger maximum, int length) {
        Requires.positive((int)length);
        Random r = RandomRegistry.random();
        return MSeq.ofLength((int)length).fill(() -> new BigIntegerGene(random.nextBigInteger(minimum, maximum, r), minimum, maximum)).toISeq();
    }

    public static BigIntegerGene of(BigInteger value, BigInteger min, BigInteger max) {
        return new BigIntegerGene(value, min, max);
    }

    public static BigIntegerGene of(BigInteger min, BigInteger max) {
        return BigIntegerGene.of(random.nextBigInteger(min, max, RandomRegistry.random()), min, max);
    }
}

