/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext;

import io.jenetics.Chromosome;
import io.jenetics.Mutator;
import io.jenetics.MutatorResult;
import io.jenetics.ext.TreeGene;
import io.jenetics.ext.util.FlatTree;
import io.jenetics.ext.util.FlatTreeNode;
import io.jenetics.ext.util.Tree;
import io.jenetics.ext.util.TreeNode;
import io.jenetics.internal.math.Probabilities;
import io.jenetics.util.ISeq;
import java.util.Random;

public abstract class TreeMutator<A, G extends TreeGene<A, G>, C extends Comparable<? super C>>
extends Mutator<G, C> {
    public TreeMutator() {
        this(0.2);
    }

    public TreeMutator(double probability) {
        super(probability);
    }

    protected MutatorResult<Chromosome<G>> mutate(Chromosome<G> chromosome, double p, Random random2) {
        int P = Probabilities.toInt((double)p);
        return random2.nextInt() < P ? this.mutate(chromosome) : MutatorResult.of(chromosome);
    }

    private MutatorResult<Chromosome<G>> mutate(Chromosome<G> chromosome) {
        TreeNode tree = TreeNode.ofTree((Tree)chromosome.gene());
        this.mutate(tree);
        FlatTreeNode flat = FlatTreeNode.of(tree);
        ISeq<TreeGene> genes = flat.map(t -> this.gene((G)((TreeGene)chromosome.gene()), (FlatTree<? extends A, ?>)t));
        return MutatorResult.of((Object)chromosome.newInstance(genes), (int)1);
    }

    private G gene(G template, FlatTree<? extends A, ?> tree) {
        return template.newInstance(tree.value(), tree.childOffset(), tree.childCount());
    }

    protected abstract void mutate(TreeNode<A> var1);
}

