/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.moea;

import io.jenetics.Optimize;
import io.jenetics.ext.moea.ElementComparator;
import io.jenetics.ext.moea.ElementDistance;
import io.jenetics.ext.moea.GeneralDoubleVec;
import io.jenetics.ext.moea.Pareto;
import io.jenetics.ext.moea.Vec;
import io.jenetics.ext.moea.VecFactory;
import io.jenetics.ext.moea.Vecs;
import java.util.Comparator;
import java.util.List;

final class GeneralDoubleVecFactory
implements VecFactory<double[]> {
    private final boolean[] _maximisations;
    private final ElementComparator<double[]> _comparator = this::cmp;
    private final ElementDistance<double[]> _distance = this::dst;
    private final Comparator<double[]> _dominance = this::dom;

    GeneralDoubleVecFactory(List<Optimize> optimizes) {
        Vecs.checkVecLength(optimizes.size());
        this._maximisations = Vecs.toFlags(optimizes);
    }

    private int cmp(double[] u, double[] v, int i) {
        return this._maximisations[i] ? Double.compare(u[i], v[i]) : Double.compare(v[i], u[i]);
    }

    private double dst(double[] u, double[] v, int i) {
        return this._maximisations[i] ? u[i] - v[i] : v[i] - u[i];
    }

    private int dom(double[] u, double[] v) {
        return Pareto.dominance(u, v, this._maximisations.length, this::cmp);
    }

    @Override
    public Vec<double[]> newVec(double[] array) {
        Vecs.requireVecLength(this._maximisations.length, array.length);
        return new GeneralDoubleVec(array, this._comparator, this._distance, this._dominance);
    }

    public String toString() {
        return String.format("VecFactory<double[%d]>", this._maximisations.length);
    }
}

