/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.moea;

import io.jenetics.Optimize;
import io.jenetics.ext.moea.ElementComparator;
import io.jenetics.ext.moea.ElementDistance;
import io.jenetics.ext.moea.GeneralIntVec;
import io.jenetics.ext.moea.Pareto;
import io.jenetics.ext.moea.Vec;
import io.jenetics.ext.moea.VecFactory;
import io.jenetics.ext.moea.Vecs;
import java.util.Comparator;
import java.util.List;

final class GeneralIntVecFactory
implements VecFactory<int[]> {
    private final boolean[] _maximisations;
    private final ElementComparator<int[]> _comparator = this::cmp;
    private final ElementDistance<int[]> _distance = this::dst;
    private final Comparator<int[]> _dominance = this::dom;

    GeneralIntVecFactory(List<Optimize> optimizes) {
        Vecs.checkVecLength(optimizes.size());
        this._maximisations = Vecs.toFlags(optimizes);
    }

    private int cmp(int[] u, int[] v, int i) {
        return this._maximisations[i] ? Integer.compare(u[i], v[i]) : Integer.compare(v[i], u[i]);
    }

    private double dst(int[] u, int[] v, int i) {
        return this._maximisations[i] ? (double)(u[i] - v[i]) : (double)(v[i] - u[i]);
    }

    private int dom(int[] u, int[] v) {
        return Pareto.dominance(u, v, this._maximisations.length, this::cmp);
    }

    @Override
    public Vec<int[]> newVec(int[] array) {
        Vecs.requireVecLength(this._maximisations.length, array.length);
        return new GeneralIntVec(array, this._comparator, this._distance, this._dominance);
    }

    public String toString() {
        return String.format("VecFactory<int[%d]>", this._maximisations.length);
    }
}

