/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.moea;

import io.jenetics.Optimize;
import io.jenetics.ext.moea.ElementComparator;
import io.jenetics.ext.moea.ElementDistance;
import io.jenetics.ext.moea.GeneralLongVec;
import io.jenetics.ext.moea.Pareto;
import io.jenetics.ext.moea.Vec;
import io.jenetics.ext.moea.VecFactory;
import io.jenetics.ext.moea.Vecs;
import java.util.Comparator;
import java.util.List;

final class GeneralLongVecFactory
implements VecFactory<long[]> {
    private final boolean[] _maximisations;
    private final ElementComparator<long[]> _comparator = this::cmp;
    private final ElementDistance<long[]> _distance = this::dst;
    private final Comparator<long[]> _dominance = this::dom;

    GeneralLongVecFactory(List<Optimize> optimizes) {
        Vecs.checkVecLength(optimizes.size());
        this._maximisations = Vecs.toFlags(optimizes);
    }

    private int cmp(long[] u, long[] v, int i) {
        return this._maximisations[i] ? Long.compare(u[i], v[i]) : Long.compare(v[i], u[i]);
    }

    private double dst(long[] u, long[] v, int i) {
        return this._maximisations[i] ? (double)(u[i] - v[i]) : (double)(v[i] - u[i]);
    }

    private int dom(long[] u, long[] v) {
        return Pareto.dominance(u, v, this._maximisations.length, this::cmp);
    }

    @Override
    public Vec<long[]> newVec(long[] array) {
        Vecs.requireVecLength(this._maximisations.length, array.length);
        return new GeneralLongVec(array, this._comparator, this._distance, this._dominance);
    }

    public String toString() {
        return String.format("VecFactory<long[%d]>", this._maximisations.length);
    }
}

