/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.moea;

import io.jenetics.ext.internal.IntList;
import io.jenetics.ext.moea.ElementComparator;
import io.jenetics.ext.moea.ElementDistance;
import io.jenetics.ext.moea.Vec;
import io.jenetics.util.ISeq;
import io.jenetics.util.MSeq;
import io.jenetics.util.ProxySorter;
import io.jenetics.util.Seq;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.ToIntFunction;

public final class Pareto {
    private Pareto() {
    }

    public static <T> double[] crowdingDistance(Seq<? extends Vec<T>> set) {
        return Pareto.crowdingDistance(set, Vec::compare, Vec::distance, Vec::length);
    }

    public static <T> double[] crowdingDistance(Seq<? extends T> set, ElementComparator<? super T> comparator, ElementDistance<? super T> distance, ToIntFunction<? super T> dimension) {
        Objects.requireNonNull(set);
        Objects.requireNonNull(comparator);
        Objects.requireNonNull(distance);
        double[] result = new double[set.size()];
        if (set.size() < 3) {
            Arrays.fill(result, Double.POSITIVE_INFINITY);
        } else {
            int d = dimension.applyAsInt(set.get(0));
            for (int m = 0; m < d; ++m) {
                Object min;
                int[] idx = ProxySorter.sort(set, comparator.ofIndex(m).reversed());
                result[idx[0]] = Double.POSITIVE_INFINITY;
                result[idx[set.size() - 1]] = Double.POSITIVE_INFINITY;
                Object max = set.get(idx[0]);
                double dm = distance.distance(max, min = set.get(idx[set.size() - 1]), m);
                if (Double.compare(dm, 0.0) <= 0) continue;
                int n = set.size() - 1;
                for (int i = 1; i < n; ++i) {
                    double dist = distance.distance(set.get(idx[i - 1]), set.get(idx[i + 1]), m);
                    int n2 = idx[i];
                    result[n2] = result[n2] + dist / dm;
                }
            }
        }
        return result;
    }

    public static <T> int[] rank(Seq<? extends Vec<T>> set) {
        return Pareto.rank(set, Vec::dominance);
    }

    public static <T> int[] rank(Seq<? extends T> set, Comparator<? super T> dominance) {
        int[][] d = new int[set.size()][set.size()];
        for (int i = 0; i < set.size(); ++i) {
            for (int j = i + 1; j < set.size(); ++j) {
                d[i][j] = dominance.compare(set.get(i), set.get(j));
                d[j][i] = -d[i][j];
            }
        }
        int[] nq = new int[set.size()];
        ArrayList<IntList> fronts = new ArrayList<IntList>();
        IntList Fi = new IntList();
        for (int p = 0; p < set.size(); ++p) {
            IntList Sp = new IntList();
            int np = 0;
            for (int q = 0; q < set.size(); ++q) {
                if (p == q) continue;
                if (d[p][q] > 0) {
                    Sp.add(q);
                    continue;
                }
                if (d[q][p] <= 0) continue;
                ++np;
            }
            if (np == 0) {
                Fi.add(p);
            }
            fronts.add(Sp);
            nq[p] = np;
        }
        int i = 0;
        int[] ranks = new int[set.size()];
        while (!Fi.isEmpty()) {
            IntList Q = new IntList();
            for (int p = 0; p < Fi.size(); ++p) {
                int fi = Fi.get(p);
                ranks[fi] = i;
                int n = ((IntList)fronts.get(fi)).size();
                for (int k = 0; k < n; ++k) {
                    int q;
                    int n2 = q = ((IntList)fronts.get(fi)).get(k);
                    nq[n2] = nq[n2] - 1;
                    if (nq[q] != 0) continue;
                    Q.add(q);
                }
            }
            ++i;
            Fi = Q;
        }
        return ranks;
    }

    public static <T> ISeq<Vec<T>> front(Seq<? extends Vec<T>> set) {
        return Pareto.front(set, Vec::dominance);
    }

    public static <T> ISeq<T> front(Seq<? extends T> set, Comparator<? super T> dominance) {
        MSeq front = MSeq.of(set);
        int n = front.size();
        block0: for (int i = 0; i < n; ++i) {
            int j = i + 1;
            while (j < n) {
                if (dominance.compare(front.get(i), front.get(j)) > 0) {
                    front.swap(j, --n);
                    continue;
                }
                if (dominance.compare(front.get(j), front.get(i)) > 0) {
                    front.swap(i, --n);
                    --i;
                    continue block0;
                }
                ++j;
            }
        }
        return ((MSeq)front.subSeq(0, n).copy()).toISeq();
    }

    public static <C extends Comparable<? super C>> int dominance(C[] u, C[] v) {
        return Pareto.dominance(u, v, Comparator.naturalOrder());
    }

    public static <T> int dominance(T[] u, T[] v, Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        Pareto.checkLength(u.length, v.length);
        return Pareto.dominance(u, v, u.length, (a, b, i) -> comparator.compare(a[i], b[i]));
    }

    public static int dominance(int[] u, int[] v) {
        Pareto.checkLength(u.length, v.length);
        return Pareto.dominance(u, v, u.length, (a, b, i) -> Integer.compare(a[i], b[i]));
    }

    public static int dominance(long[] u, long[] v) {
        Pareto.checkLength(u.length, v.length);
        return Pareto.dominance(u, v, u.length, (a, b, i) -> Long.compare(a[i], b[i]));
    }

    public static int dominance(double[] u, double[] v) {
        Pareto.checkLength(u.length, v.length);
        return Pareto.dominance(u, v, u.length, (a, b, i) -> Double.compare(a[i], b[i]));
    }

    private static void checkLength(int i, int j) {
        if (i != j) {
            throw new IllegalArgumentException(String.format("Length are not equals: %d != %d.", i, j));
        }
    }

    public static <V> int dominance(V u, V v, int dimensions, ElementComparator<? super V> comparator) {
        boolean udominated = false;
        boolean vdominated = false;
        for (int i = 0; i < dimensions; ++i) {
            int cmp = comparator.compare(u, v, i);
            if (cmp > 0) {
                if (vdominated) {
                    return 0;
                }
                udominated = true;
                continue;
            }
            if (cmp >= 0) continue;
            if (udominated) {
                return 0;
            }
            vdominated = true;
        }
        if (udominated == vdominated) {
            return 0;
        }
        if (udominated) {
            return 1;
        }
        return -1;
    }
}

