/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.moea;

import io.jenetics.ext.moea.ElementComparator;
import io.jenetics.ext.moea.ElementDistance;
import io.jenetics.ext.moea.Pareto;
import io.jenetics.internal.util.Arrays;
import io.jenetics.util.ISeq;
import io.jenetics.util.ProxySorter;
import io.jenetics.util.Seq;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class ParetoFront<T>
extends AbstractSet<T> {
    private final List<T> _population = new ArrayList<T>();
    private final Comparator<? super T> _dominance;
    private final BiPredicate<? super T, ? super T> _equals;

    public ParetoFront(Comparator<? super T> dominance, BiPredicate<? super T, ? super T> equals) {
        this._dominance = Objects.requireNonNull(dominance);
        this._equals = Objects.requireNonNull(equals);
    }

    public ParetoFront(Comparator<? super T> dominance) {
        this(dominance, Objects::equals);
    }

    @Override
    public boolean add(T element) {
        Objects.requireNonNull(element);
        boolean updated = false;
        Iterator<T> iterator = this._population.iterator();
        while (iterator.hasNext()) {
            T existing = iterator.next();
            int cmp = this._dominance.compare(element, existing);
            if (cmp > 0) {
                iterator.remove();
                updated = true;
                continue;
            }
            if (cmp >= 0 && !this._equals.test(element, existing)) continue;
            return updated;
        }
        this._population.add(element);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> elements) {
        int sum = elements.stream().mapToInt(e -> this.add((T)e) ? 1 : 0).sum();
        return sum > 0;
    }

    public ParetoFront<T> merge(ParetoFront<? extends T> elements) {
        this.addAll((Collection<? extends T>)elements);
        return this;
    }

    public ParetoFront<T> trim(int size, ElementComparator<? super T> comparator, ElementDistance<? super T> distance, ToIntFunction<? super T> dimension) {
        Objects.requireNonNull(comparator);
        Objects.requireNonNull(distance);
        Objects.requireNonNull(dimension);
        if (this.size() > size) {
            double[] distances = Pareto.crowdingDistance(Seq.viewOf(this._population), comparator, distance, dimension);
            int[] indexes = ProxySorter.sort((double[])distances);
            Arrays.revert((int[])indexes);
            List list = IntStream.of(indexes).limit(size).mapToObj(this._population::get).collect(Collectors.toList());
            this._population.clear();
            this._population.addAll(list);
        }
        return this;
    }

    @Override
    public Iterator<T> iterator() {
        return this._population.iterator();
    }

    @Override
    public int size() {
        return this._population.size();
    }

    @Override
    public boolean isEmpty() {
        return this._population.isEmpty();
    }

    public ISeq<T> toISeq() {
        return ISeq.of(this._population);
    }

    public static <C extends Comparable<? super C>> Collector<C, ?, ParetoFront<C>> toParetoFront() {
        return ParetoFront.toParetoFront(Comparator.naturalOrder());
    }

    public static <T> Collector<T, ?, ParetoFront<T>> toParetoFront(Comparator<? super T> dominance) {
        return Collector.of(() -> new ParetoFront(dominance), ParetoFront::add, ParetoFront::merge, new Collector.Characteristics[0]);
    }
}

