/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.moea;

import io.jenetics.ext.moea.ElementComparator;
import io.jenetics.ext.moea.ElementDistance;
import io.jenetics.ext.moea.Pareto;
import io.jenetics.ext.moea.Serial;
import io.jenetics.ext.moea.Vec;
import io.jenetics.ext.moea.Vecs;
import io.jenetics.internal.util.SerialIO;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

final class SimpleIntVec
implements Vec<int[]>,
Serializable {
    private static final long serialVersionUID = 2L;
    private final int[] _data;

    SimpleIntVec(int[] data) {
        Vecs.checkVecLength(data.length);
        this._data = data;
    }

    @Override
    public int[] data() {
        return this._data;
    }

    @Override
    public int length() {
        return this._data.length;
    }

    @Override
    public ElementComparator<int[]> comparator() {
        return SimpleIntVec::cmp;
    }

    private static int cmp(int[] u, int[] v, int i) {
        return Integer.compare(u[i], v[i]);
    }

    @Override
    public ElementDistance<int[]> distance() {
        return SimpleIntVec::dist;
    }

    private static double dist(int[] u, int[] v, int i) {
        return u[i] - v[i];
    }

    @Override
    public Comparator<int[]> dominance() {
        return Pareto::dominance;
    }

    public int hashCode() {
        return Arrays.hashCode(this._data);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof SimpleIntVec && Arrays.equals(((SimpleIntVec)obj)._data, this._data);
    }

    public String toString() {
        return Arrays.toString(this._data);
    }

    private Object writeReplace() {
        return new Serial(1, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(DataOutput out) throws IOException {
        SerialIO.writeIntArray((int[])this._data, (DataOutput)out);
    }

    static SimpleIntVec read(DataInput in) throws IOException {
        return new SimpleIntVec(SerialIO.readIntArray((DataInput)in));
    }
}

