/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.moea;

import io.jenetics.ext.moea.ElementComparator;
import io.jenetics.ext.moea.ElementDistance;
import io.jenetics.ext.moea.Vec;
import io.jenetics.ext.moea.Vecs;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;

final class SimpleObjectVec<T>
implements Vec<T[]> {
    private final T[] _data;
    private final Comparator<? super T> _comparator;
    private final ElementDistance<T[]> _distance;

    SimpleObjectVec(T[] data, Comparator<? super T> comparator, ElementDistance<T[]> distance) {
        Vecs.checkVecLength(data.length);
        this._data = data;
        this._comparator = Objects.requireNonNull(comparator);
        this._distance = Objects.requireNonNull(distance);
    }

    @Override
    public T[] data() {
        return this._data;
    }

    @Override
    public int length() {
        return this._data.length;
    }

    @Override
    public ElementComparator<T[]> comparator() {
        return (u, v, i) -> this._comparator.compare(u[i], v[i]);
    }

    @Override
    public ElementDistance<T[]> distance() {
        return this._distance;
    }

    @Override
    public Comparator<T[]> dominance() {
        return (u, v) -> Vec.dominance(u, v, this._comparator);
    }

    public int hashCode() {
        return Arrays.hashCode(this._data);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof SimpleObjectVec && Arrays.equals(((SimpleObjectVec)obj)._data, this._data);
    }

    public String toString() {
        return Arrays.toString(this._data);
    }
}

