/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.moea;

import io.jenetics.Optimize;
import io.jenetics.ext.moea.ElementDistance;
import io.jenetics.ext.moea.GeneralDoubleVecFactory;
import io.jenetics.ext.moea.GeneralIntVecFactory;
import io.jenetics.ext.moea.GeneralLongVecFactory;
import io.jenetics.ext.moea.GeneralObjectVecFactory;
import io.jenetics.ext.moea.Vec;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

@FunctionalInterface
public interface VecFactory<T> {
    public Vec<T> newVec(T var1);

    public static VecFactory<int[]> ofIntVec(List<Optimize> optimizes) {
        return new GeneralIntVecFactory(optimizes);
    }

    public static VecFactory<int[]> ofIntVec(Optimize ... optimizes) {
        return VecFactory.ofIntVec(Arrays.asList(optimizes));
    }

    public static VecFactory<int[]> ofIntVec() {
        return Vec::of;
    }

    public static VecFactory<long[]> ofLongVec(List<Optimize> optimizes) {
        return new GeneralLongVecFactory(optimizes);
    }

    public static VecFactory<long[]> ofLongVec(Optimize ... optimizes) {
        return VecFactory.ofLongVec(Arrays.asList(optimizes));
    }

    public static VecFactory<long[]> ofLongVec() {
        return Vec::of;
    }

    public static VecFactory<double[]> ofDoubleVec(List<Optimize> optimizes) {
        return new GeneralDoubleVecFactory(optimizes);
    }

    public static VecFactory<double[]> ofDoubleVec(Optimize ... optimizes) {
        return VecFactory.ofDoubleVec(Arrays.asList(optimizes));
    }

    public static VecFactory<double[]> ofDoubleVec() {
        return Vec::of;
    }

    public static <T> VecFactory<T[]> ofObjectVec(Comparator<? super T> comparator, ElementDistance<T[]> distance, List<Optimize> optimizes) {
        return new GeneralObjectVecFactory<T>(comparator, distance, optimizes);
    }

    public static <T> VecFactory<T[]> ofObjectVec(Comparator<? super T> comparator, ElementDistance<T[]> distance, Optimize ... optimizes) {
        return VecFactory.ofObjectVec(comparator, distance, Arrays.asList(optimizes));
    }
}

