/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.rewriting;

import io.jenetics.ext.rewriting.Serial;
import io.jenetics.ext.rewriting.TreeMatchResult;
import io.jenetics.ext.rewriting.TreePattern;
import io.jenetics.ext.rewriting.TreeRewriter;
import io.jenetics.ext.util.Tree;
import io.jenetics.ext.util.TreeNode;
import io.jenetics.internal.util.Hashes;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class TreeRewriteRule<V>
implements TreeRewriter<V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final TreePattern<V> _left;
    private final TreePattern<V> _right;

    public TreeRewriteRule(TreePattern<V> left, TreePattern<V> right) {
        this._left = Objects.requireNonNull(left);
        this._right = Objects.requireNonNull(right);
        HashSet<TreePattern.Var<V>> undefined = new HashSet<TreePattern.Var<V>>(this._right.vars());
        undefined.removeAll(this._left.vars());
        if (!undefined.isEmpty()) {
            throw new IllegalArgumentException(String.format("Some template variables are not defined in the matcher '%s': %s", this, undefined.stream().map((? super T v) -> String.format("%s", v)).collect(Collectors.joining(", "))));
        }
    }

    public TreePattern<V> left() {
        return this._left;
    }

    public TreePattern<V> right() {
        return this._right;
    }

    public <B> TreeRewriteRule<B> map(Function<? super V, ? extends B> mapper) {
        return new TreeRewriteRule<B>(this._left.map(mapper), this._right.map(mapper));
    }

    @Override
    public int rewrite(TreeNode<V> tree, int limit) {
        Optional<TreeMatchResult<V>> result;
        Objects.requireNonNull(tree);
        int rewritten = 0;
        do {
            result = this.left().matcher(tree).results().findFirst();
            result.ifPresent(res -> this.rewrite((TreeMatchResult<V>)res, tree));
        } while (result.isPresent() && (rewritten += result.isPresent() ? 1 : 0) < limit);
        return rewritten;
    }

    private void rewrite(TreeMatchResult<V> result, TreeNode<V> tree) {
        Map<TreePattern.Var<V>, Tree<V, ?>> vars = result.vars();
        TreeNode<V> r = this._right.expand(vars);
        Tree.Path path = result.tree().childPath();
        tree.replaceAtPath(path, r);
    }

    public int hashCode() {
        return Hashes.hash(this._left, (int)Hashes.hash(this._right));
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof TreeRewriteRule && this._left.equals(((TreeRewriteRule)obj)._left) && this._right.equals(((TreeRewriteRule)obj)._right);
    }

    public String toString() {
        return String.format("%s -> %s", this._left, this._right);
    }

    public static <V> TreeRewriteRule<V> parse(String rule, Function<? super String, ? extends V> mapper) {
        String[] parts = rule.split("->");
        if (parts.length == 1) {
            throw new IllegalArgumentException(String.format("Invalid rewrite rule; missing separator '->': %s", rule));
        }
        if (parts.length > 2) {
            throw new IllegalArgumentException(String.format("Invalid rewrite rule; found %d separators '->': %s", parts.length - 1, rule));
        }
        return new TreeRewriteRule<V>(TreePattern.compile(parts[0], mapper), TreePattern.compile(parts[1], mapper));
    }

    public static TreeRewriteRule<String> parse(String rule) {
        return TreeRewriteRule.parse(rule, Function.identity());
    }

    private Object writeReplace() {
        return new Serial(4, this);
    }

    private void readObject(ObjectOutputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(ObjectOutput out) throws IOException {
        out.writeObject(this._left);
        out.writeObject(this._right);
    }

    static Object read(ObjectInput in) throws IOException, ClassNotFoundException {
        TreePattern left = (TreePattern)in.readObject();
        TreePattern right = (TreePattern)in.readObject();
        return new TreeRewriteRule(left, right);
    }
}

