/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.rewriting;

import io.jenetics.ext.util.TreeNode;
import java.util.Arrays;
import java.util.Objects;

@FunctionalInterface
public interface TreeRewriter<V> {
    public int rewrite(TreeNode<V> var1, int var2);

    default public int rewrite(TreeNode<V> tree) {
        return this.rewrite(tree, Integer.MAX_VALUE);
    }

    public static <V> int rewrite(TreeNode<V> tree, int limit, Iterable<? extends TreeRewriter<V>> rewriters) {
        Objects.requireNonNull(tree);
        Objects.requireNonNull(rewriters);
        if (limit < 0) {
            throw new IllegalArgumentException(String.format("Limit is smaller then zero: %d", limit));
        }
        int rewritten = 0;
        int count = 0;
        do {
            count = 0;
            for (TreeRewriter<V> rw : rewriters) {
                count += rw.rewrite(tree, limit - rewritten);
            }
        } while (count > 0 && (rewritten += count) < limit);
        return rewritten;
    }

    public static <V> int rewrite(TreeNode<V> tree, Iterable<? extends TreeRewriter<V>> rewriters) {
        return TreeRewriter.rewrite(tree, Integer.MAX_VALUE, rewriters);
    }

    @SafeVarargs
    public static <V> TreeRewriter<V> concat(TreeRewriter<V> ... rewriters) {
        if (rewriters.length == 0) {
            throw new IllegalArgumentException("The given rewriter array must not be empty.");
        }
        return (tree, limit) -> TreeRewriter.rewrite(tree, limit, Arrays.asList(rewriters));
    }
}

