/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.util;

import io.jenetics.ext.util.TreeChildIterator;
import io.jenetics.ext.util.TreeFormatter;
import io.jenetics.ext.util.TreeNodeBreadthFirstIterator;
import io.jenetics.ext.util.TreeNodePathIterator;
import io.jenetics.ext.util.TreeNodePostorderIterator;
import io.jenetics.ext.util.TreeNodePreorderIterator;
import io.jenetics.ext.util.Trees;
import io.jenetics.util.ISeq;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface Tree<V, T extends Tree<V, T>>
extends Iterable<T> {
    default public V value() {
        return this.getValue();
    }

    @Deprecated
    public V getValue();

    default public Optional<T> parent() {
        return this.getParent();
    }

    @Deprecated
    public Optional<T> getParent();

    public T childAt(int var1);

    public int childCount();

    default public Iterator<T> childIterator() {
        return new TreeChildIterator(Trees.self(this));
    }

    default public Stream<T> childStream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.childIterator(), 0), false);
    }

    default public boolean isRoot() {
        return !this.parent().isPresent();
    }

    default public int depth() {
        Iterator<T> it = this.breadthFirstIterator();
        Tree last = null;
        while (it.hasNext()) {
            last = (Tree)it.next();
        }
        if (!1.$assertionsDisabled && last == null) {
            throw new AssertionError();
        }
        return last.level() - this.level();
    }

    default public int level() {
        Optional<Tree<V, T>> ancestor = Optional.of(Trees.self(this));
        int levels = 0;
        while ((ancestor = ancestor.flatMap(Tree::parent)).isPresent()) {
            ++levels;
        }
        return levels;
    }

    default public int indexOf(Tree<?, ?> child) {
        int index = -1;
        int n = this.childCount();
        for (int i = 0; i < n && index == -1; ++i) {
            if (!this.childAt(i).identical(child)) continue;
            index = i;
        }
        return index;
    }

    default public int size() {
        return Trees.countChildren(this) + 1;
    }

    default public Optional<T> childAtPath(Path path) {
        Object node = Trees.self(this);
        for (int i = 0; i < path.length() && node != null; ++i) {
            node = path.get(i) < node.childCount() ? node.childAt(path.get(i)) : null;
        }
        return Optional.ofNullable(node);
    }

    default public Optional<T> childAtPath(int ... path) {
        return this.childAtPath(Path.of(path));
    }

    default public boolean isAncestor(Tree<?, ?> node) {
        boolean result;
        Objects.requireNonNull(node);
        Optional<Tree<V, T>> ancestor = Optional.of(Trees.self(this));
        while (!(result = ancestor.filter(a -> a.identical(node)).isPresent()) && (ancestor = ancestor.flatMap(Tree::parent)).isPresent()) {
        }
        return result;
    }

    default public boolean isDescendant(Tree<?, ?> node) {
        return Objects.requireNonNull(node).isAncestor(this);
    }

    default public Optional<T> sharedAncestor(Tree<?, ?> node) {
        Objects.requireNonNull(node);
        Object ancestor = null;
        if (node.identical(this)) {
            ancestor = Trees.self(this);
        } else {
            Object node2;
            Tree<Object, Object> node1;
            int diff;
            int level1 = this.level();
            int level2 = node.level();
            if (level2 > level1) {
                diff = level2 - level1;
                node1 = node;
                node2 = Trees.self(this);
            } else {
                diff = level1 - level2;
                node1 = Trees.self(this);
                node2 = node;
            }
            while (diff > 0 && node1 != null) {
                node1 = node1.parent().orElse(null);
                --diff;
            }
            do {
                if (node1 != null && node1.identical((Tree<?, ?>)node2)) {
                    ancestor = Trees.self(node1);
                }
                node1 = node1 != null ? (Tree)node1.parent().orElse(null) : null;
                node2 = node2.parent().orElse(null);
            } while (node1 != null && node2 != null && ancestor == null);
        }
        return Optional.ofNullable(ancestor);
    }

    default public boolean isRelated(Tree<?, ?> node) {
        Objects.requireNonNull(node);
        return node.root().identical((Tree<?, ?>)this.root());
    }

    @Deprecated
    default public ISeq<T> getPath() {
        return Trees.pathElementsFromRoot(Trees.self(this), 0).toISeq();
    }

    default public ISeq<T> pathElements() {
        return Trees.pathElementsFromRoot(Trees.self(this), 0).toISeq();
    }

    default public Path path() {
        int[] p = Trees.pathFromRoot(Trees.self(this), 0);
        return Path.of(p);
    }

    default public T root() {
        return this.getRoot();
    }

    @Deprecated
    default public T getRoot() {
        Object prev;
        Object anc = Trees.self(this);
        do {
            prev = anc;
        } while ((anc = (Tree)anc.parent().orElse(null)) != null);
        return prev;
    }

    default public boolean isChild(Tree<?, ?> node) {
        Objects.requireNonNull(node);
        return this.childCount() != 0 && node.parent().equals(Optional.of(Trees.self(this)));
    }

    default public Optional<T> firstChild() {
        return this.childCount() > 0 ? Optional.of(this.childAt(0)) : Optional.empty();
    }

    default public Optional<T> lastChild() {
        return this.childCount() > 0 ? Optional.of(this.childAt(this.childCount() - 1)) : Optional.empty();
    }

    default public Optional<T> childAfter(Tree<?, ?> child) {
        Objects.requireNonNull(child);
        int index = this.indexOf(child);
        if (index == -1) {
            throw new IllegalArgumentException("The given node is not a child.");
        }
        return index < this.childCount() - 1 ? Optional.of(this.childAt(index + 1)) : Optional.empty();
    }

    default public Optional<T> childBefore(Tree<?, ?> child) {
        Objects.requireNonNull(child);
        int index = this.indexOf(child);
        if (index == -1) {
            throw new IllegalArgumentException("The given node is not a child.");
        }
        return index > 0 ? Optional.of(this.childAt(index - 1)) : Optional.empty();
    }

    default public Optional<T> nextNode() {
        Optional next = Optional.empty();
        if (this.childCount() == 0) {
            Object node = Trees.self(this);
            while (node != null && !(next = node.nextSibling()).isPresent()) {
                node = node.parent().orElse(null);
            }
        } else {
            next = Optional.of(this.childAt(0));
        }
        return next;
    }

    default public Optional<T> previousNode() {
        Optional<Object> node = Optional.empty();
        if (this.parent().isPresent()) {
            Optional<Tree> prev = this.previousSibling();
            node = prev.isPresent() ? (((Tree)prev.get()).childCount() == 0 ? prev : prev.map(Tree::lastLeaf)) : this.parent();
        }
        return node;
    }

    default public boolean isSibling(Tree<?, ?> node) {
        return this.identical(Objects.requireNonNull(node)) || this.parent().equals(node.parent());
    }

    default public int siblingCount() {
        return this.parent().map(Tree::childCount).orElse(1);
    }

    default public Optional<T> nextSibling() {
        return this.parent().flatMap(p -> p.childAfter((Tree<?, ?>)Trees.self(this)));
    }

    default public Optional<T> previousSibling() {
        return this.parent().flatMap(p -> p.childBefore((Tree<?, ?>)Trees.self(this)));
    }

    default public boolean isLeaf() {
        return this.childCount() == 0;
    }

    default public T firstLeaf() {
        Object leaf = Trees.self(this);
        while (!leaf.isLeaf()) {
            leaf = (Tree)leaf.firstChild().orElseThrow(AssertionError::new);
        }
        return leaf;
    }

    default public T lastLeaf() {
        Object leaf = Trees.self(this);
        while (!leaf.isLeaf()) {
            leaf = (Tree)leaf.lastChild().orElseThrow(AssertionError::new);
        }
        return leaf;
    }

    default public Optional<T> nextLeaf() {
        return this.nextSibling().map(s -> Optional.of(s.firstLeaf())).orElseGet(() -> this.parent().flatMap(Tree::nextLeaf));
    }

    default public Optional<T> previousLeaf() {
        return this.previousSibling().map(s -> Optional.of(s.lastLeaf())).orElseGet(() -> this.parent().flatMap(Tree::previousLeaf));
    }

    default public int leafCount() {
        return (int)this.breadthFirstStream().filter(Tree::isLeaf).count();
    }

    default public Iterator<T> breadthFirstIterator() {
        return new TreeNodeBreadthFirstIterator(Trees.self(this));
    }

    @Override
    default public Iterator<T> iterator() {
        return this.breadthFirstIterator();
    }

    default public Stream<T> breadthFirstStream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.breadthFirstIterator(), 0), false);
    }

    default public Stream<T> stream() {
        return this.breadthFirstStream();
    }

    default public Iterator<T> preorderIterator() {
        return new TreeNodePreorderIterator(Trees.self(this));
    }

    default public Stream<T> preorderStream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.preorderIterator(), 0), false);
    }

    default public Iterator<T> postorderIterator() {
        return new TreeNodePostorderIterator(Trees.self(this));
    }

    default public Stream<T> postorderStream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.postorderIterator(), 0), false);
    }

    default public Iterator<T> depthFirstIterator() {
        return this.postorderIterator();
    }

    default public Stream<T> depthFirstStream() {
        return this.postorderStream();
    }

    default public Iterator<T> pathFromAncestorIterator(Tree<?, ?> ancestor) {
        return new TreeNodePathIterator(ancestor, Trees.self(this));
    }

    default public Path childPath() {
        Iterator<T> it = this.pathFromAncestorIterator((Tree<?, ?>)this.root());
        int[] path = new int[this.level()];
        Tree tree = null;
        int index = 0;
        while (it.hasNext()) {
            Tree child = (Tree)it.next();
            if (tree != null) {
                path[index++] = tree.indexOf(child);
            }
            tree = child;
        }
        if (!1.$assertionsDisabled && index != path.length) {
            throw new AssertionError();
        }
        return new Path(path);
    }

    default public boolean identical(Tree<?, ?> other) {
        return this == other;
    }

    default public String toParenthesesString(Function<? super V, String> mapper) {
        return TreeFormatter.PARENTHESES.format(this, mapper);
    }

    default public String toParenthesesString() {
        return this.toParenthesesString(Objects::toString);
    }

    public static int hashCode(Tree<?, ?> tree) {
        return tree != null ? tree.breadthFirstStream().mapToInt(node -> 31 * Objects.hashCode(node.value()) + 37).sum() + 17 : 0;
    }

    public static boolean equals(Tree<?, ?> a, Tree<?, ?> b) {
        return Trees.equals(a, b);
    }

    public static String toString(Tree<?, ?> tree) {
        return tree.toParenthesesString();
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static final class Path
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int[] _path;

        private Path(int[] path) {
            this._path = Objects.requireNonNull(path);
        }

        public int length() {
            return this._path.length;
        }

        public int get(int index) {
            return this._path[index];
        }

        public int[] toArray() {
            return (int[])this._path.clone();
        }

        public Path append(Path path) {
            int[] p = new int[this.length() + path.length()];
            System.arraycopy(this._path, 0, p, 0, this.length());
            System.arraycopy(path._path, 0, p, this.length(), path.length());
            return new Path(p);
        }

        public int hashCode() {
            return Arrays.hashCode(this._path);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Path && Arrays.equals(this._path, ((Path)obj)._path);
        }

        public String toString() {
            return Arrays.toString(this._path);
        }

        public static Path of(int ... path) {
            for (int i = 0; i < path.length; ++i) {
                if (path[i] >= 0) continue;
                throw new IllegalArgumentException(String.format("Path element at position %d is smaller than zero: %d", i, path[i]));
            }
            return new Path((int[])path.clone());
        }
    }
}

