/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.util;

import io.jenetics.ext.util.Tree;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;

final class TreeNodePathIterator<V, T extends Tree<V, T>>
implements Iterator<T> {
    private final Deque<T> _stack = new ArrayDeque<T>();

    TreeNodePathIterator(Tree<?, ?> ancestor, T descendant) {
        Objects.requireNonNull(ancestor);
        this._stack.push(Objects.requireNonNull(descendant));
        Object current = descendant;
        while (!current.identical(ancestor)) {
            current = (Tree)current.parent().orElseThrow(() -> new IllegalArgumentException(String.format("Node %s is not an ancestor of %s.", ancestor.value(), descendant.value())));
            this._stack.push(current);
        }
    }

    @Override
    public boolean hasNext() {
        return !this._stack.isEmpty();
    }

    @Override
    public T next() {
        return (T)((Tree)this._stack.pop());
    }
}

