/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext;

import io.jenetics.NumericGene;
import io.jenetics.ext.internal.util.Randoms;
import io.jenetics.internal.util.Hashes;
import io.jenetics.internal.util.Requires;
import io.jenetics.util.ISeq;
import io.jenetics.util.MSeq;
import io.jenetics.util.Mean;
import io.jenetics.util.RandomRegistry;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import java.util.random.RandomGenerator;

public final class BigIntegerGene
implements NumericGene<BigInteger, BigIntegerGene>,
Mean<BigIntegerGene>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private final BigInteger _value;
    private final BigInteger _min;
    private final BigInteger _max;

    private BigIntegerGene(BigInteger value, BigInteger min, BigInteger max) {
        this._value = Objects.requireNonNull(value);
        this._min = Objects.requireNonNull(min);
        this._max = Objects.requireNonNull(max);
    }

    public BigInteger allele() {
        return this._value;
    }

    public BigInteger min() {
        return this._min;
    }

    public BigInteger max() {
        return this._max;
    }

    public BigIntegerGene mean(BigIntegerGene that) {
        BigInteger value = this._value.add(that._value).divide(TWO);
        return BigIntegerGene.of(value, this._min, this._max);
    }

    public BigIntegerGene newInstance(Number number) {
        return BigIntegerGene.of(BigInteger.valueOf(number.longValue()), this._min, this._max);
    }

    public BigIntegerGene newInstance(BigInteger value) {
        return BigIntegerGene.of(value, this._min, this._max);
    }

    public BigIntegerGene newInstance() {
        return BigIntegerGene.of(this._min, this._max);
    }

    public int hashCode() {
        return Hashes.hash((Object)this._value, (int)Hashes.hash((Object)this._min, (int)Hashes.hash((Object)this._max, (int)Hashes.hash(this.getClass()))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof BigIntegerGene)) return false;
        BigIntegerGene other = (BigIntegerGene)obj;
        if (!Objects.equals(other._value, this._value)) return false;
        if (!Objects.equals(other._min, this._min)) return false;
        if (!Objects.equals(other._max, this._max)) return false;
        return true;
    }

    public String toString() {
        return String.format("[%s]", this._value);
    }

    static ISeq<BigIntegerGene> seq(BigInteger minimum, BigInteger maximum, int length) {
        Requires.positive((int)length);
        RandomGenerator r = RandomRegistry.random();
        return MSeq.ofLength((int)length).fill(() -> new BigIntegerGene(Randoms.nextBigInteger(minimum, maximum, r), minimum, maximum)).toISeq();
    }

    public static BigIntegerGene of(BigInteger value, BigInteger min, BigInteger max) {
        return new BigIntegerGene(value, min, max);
    }

    public static BigIntegerGene of(BigInteger min, BigInteger max) {
        return BigIntegerGene.of(Randoms.nextBigInteger(min, max, RandomRegistry.random()), min, max);
    }
}

