/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext;

import io.jenetics.Chromosome;
import io.jenetics.Gene;
import io.jenetics.Mutator;
import io.jenetics.MutatorResult;
import io.jenetics.internal.math.Probabilities;
import io.jenetics.internal.math.Subset;
import io.jenetics.util.MSeq;
import java.util.random.RandomGenerator;

public class HPRMutator<G extends Gene<?, G>, C extends Comparable<? super C>>
extends Mutator<G, C> {
    public HPRMutator(double probability) {
        super(probability);
    }

    public HPRMutator() {
        this(0.2);
    }

    protected MutatorResult<Chromosome<G>> mutate(Chromosome<G> chromosome, double p, RandomGenerator random) {
        MutatorResult result;
        if (chromosome.length() > 1) {
            int P = Probabilities.toInt((double)p);
            int[] points = Subset.next((int)chromosome.length(), (int)2, (RandomGenerator)random);
            MSeq genes = MSeq.of(chromosome);
            int mutations = (points[1] - points[0] + 1) / 2;
            int i = points[0];
            for (int j = points[1]; i < j; ++i, --j) {
                genes.swap(i, j);
                if (random.nextInt() >= P) continue;
                genes.swap(i, random.nextInt(chromosome.length()));
                ++mutations;
            }
            result = new MutatorResult((Object)chromosome.newInstance(genes.toISeq()), mutations);
        } else {
            result = new MutatorResult(chromosome, 0);
        }
        return result;
    }
}

