/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext;

import io.jenetics.Alterer;
import io.jenetics.Gene;
import io.jenetics.Mutator;
import io.jenetics.Selector;
import io.jenetics.TruncationSelector;
import io.jenetics.engine.Engine;
import io.jenetics.internal.util.Requires;

public final class MpLEvolutionStrategy<G extends Gene<?, G>, C extends Comparable<? super C>>
implements Engine.Setup<G, C> {
    private final int _mu;
    private final int _lambda;
    private final double _mutationProbability;

    public MpLEvolutionStrategy(int mu, int lambda, double mutationProbability) {
        if (mu < 2) {
            throw new IllegalArgumentException(String.format("mu (\u03bc) must be greater or equal 2: %d.", mu));
        }
        if (lambda < mu) {
            throw new IllegalArgumentException(String.format("lambda (\u03bb) must be greater or equal then \u03bc [\u03bc=%d, \u03bb=%d].", mu, lambda));
        }
        this._mu = mu;
        this._lambda = lambda;
        this._mutationProbability = Requires.probability((double)mutationProbability);
    }

    public MpLEvolutionStrategy(int mu, int lambda) {
        this(mu, lambda, 0.2);
    }

    public void apply(Engine.Builder<G, C> builder) {
        builder.populationSize(this._lambda).survivorsSize(this._mu).selector((Selector)new TruncationSelector(this._mu)).alterers((Alterer)new Mutator(this._mutationProbability), new Alterer[0]);
    }
}

