/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext;

import io.jenetics.Chromosome;
import io.jenetics.Gene;
import io.jenetics.Mutator;
import io.jenetics.MutatorResult;
import io.jenetics.internal.math.Subset;
import io.jenetics.util.MSeq;
import java.util.random.RandomGenerator;

public class RSMutator<G extends Gene<?, G>, C extends Comparable<? super C>>
extends Mutator<G, C> {
    public RSMutator(double probability) {
        super(probability);
    }

    public RSMutator() {
        this(0.2);
    }

    protected MutatorResult<Chromosome<G>> mutate(Chromosome<G> chromosome, double p, RandomGenerator random) {
        MutatorResult result;
        if (chromosome.length() > 1) {
            int[] points = Subset.next((int)(chromosome.length() + 1), (int)2, (RandomGenerator)random);
            MSeq genes = MSeq.of(chromosome);
            genes.subSeq(points[0], points[1]).reverse();
            result = new MutatorResult((Object)chromosome.newInstance(genes.toISeq()), points[1] - points[0] - 1);
        } else {
            result = new MutatorResult(chromosome, 0);
        }
        return result;
    }
}

