/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext;

import io.jenetics.Crossover;
import io.jenetics.NumericGene;
import io.jenetics.internal.math.Basics;
import io.jenetics.internal.math.Randoms;
import io.jenetics.internal.util.Requires;
import io.jenetics.util.MSeq;
import io.jenetics.util.RandomRegistry;
import java.util.random.RandomGenerator;

public class SimulatedBinaryCrossover<G extends NumericGene<?, G>, C extends Comparable<? super C>>
extends Crossover<G, C> {
    private final double _contiguity;

    public SimulatedBinaryCrossover(double probability, double contiguity) {
        super(probability);
        this._contiguity = Requires.nonNegative((double)contiguity);
    }

    public SimulatedBinaryCrossover(double probability) {
        this(probability, 2.5);
    }

    public double contiguity() {
        return this._contiguity;
    }

    protected int crossover(MSeq<G> that, MSeq<G> other) {
        return (int)Randoms.indexes((RandomGenerator)RandomRegistry.random(), (int)that.length(), (double)0.5).peek(i -> this.crossover(that, other, i)).count();
    }

    private void crossover(MSeq<G> that, MSeq<G> other, int i) {
        RandomGenerator random = RandomRegistry.random();
        double u = random.nextDouble();
        double beta = u < 0.5 ? Math.pow(2.0 * u, 1.0 / (this._contiguity + 1.0)) : (u > 0.5 ? Math.pow(0.5 / (1.0 - u), 1.0 / (this._contiguity + 1.0)) : 1.0);
        double v1 = ((NumericGene)that.get(i)).doubleValue();
        double v2 = ((NumericGene)other.get(i)).doubleValue();
        double v = random.nextBoolean() ? (v1 - v2) * 0.5 - beta * 0.5 * Math.abs(v1 - v2) : (v1 - v2) * 0.5 + beta * 0.5 * Math.abs(v1 - v2);
        double min = ((Number)((Object)((NumericGene)that.get(i)).min())).doubleValue();
        double max = ((Number)((Object)((NumericGene)that.get(i)).max())).doubleValue();
        that.set(i, (Object)((NumericGene)that.get(i)).newInstance((Number)Basics.clamp((double)v, (double)min, (double)max)));
    }

    public String toString() {
        return String.format("SimulatedBinaryCrossover[p=%f, c=%f]", this._probability, this._contiguity);
    }
}

