/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext;

import io.jenetics.ext.TreeCrossover;
import io.jenetics.ext.TreeGene;
import io.jenetics.ext.util.TreeNode;
import io.jenetics.util.ISeq;
import io.jenetics.util.RandomRegistry;
import java.util.random.RandomGenerator;

public class SingleNodeCrossover<G extends TreeGene<?, G>, C extends Comparable<? super C>>
extends TreeCrossover<G, C> {
    public SingleNodeCrossover(double probability) {
        super(probability);
    }

    public SingleNodeCrossover() {
        this(0.2);
    }

    @Override
    protected <A> int crossover(TreeNode<A> that, TreeNode<A> other) {
        return SingleNodeCrossover.swap(that, other);
    }

    static <A> int swap(TreeNode<A> that, TreeNode<A> other) {
        int changed;
        assert (that != null);
        assert (other != null);
        RandomGenerator random = RandomRegistry.random();
        ISeq seq1 = (ISeq)that.breadthFirstStream().collect(ISeq.toISeq());
        ISeq seq2 = (ISeq)other.breadthFirstStream().collect(ISeq.toISeq());
        if (seq1.length() > 1 && seq2.length() > 1) {
            TreeNode n1 = (TreeNode)seq1.get(random.nextInt(seq1.length() - 1) + 1);
            TreeNode p1 = n1.parent().orElseThrow(AssertionError::new);
            TreeNode n2 = (TreeNode)seq2.get(random.nextInt(seq2.length() - 1) + 1);
            TreeNode p2 = n2.parent().orElseThrow(AssertionError::new);
            int i1 = p1.indexOf(n1);
            int i2 = p2.indexOf(n2);
            p1.insert(i1, n2.detach());
            p2.insert(i2, n1.detach());
            changed = 2;
        } else {
            changed = 0;
        }
        return changed;
    }

    public String toString() {
        return String.format("SingleNodeCrossover[%f]", this._probability);
    }
}

