/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext;

import io.jenetics.Chromosome;
import io.jenetics.Mutator;
import io.jenetics.MutatorResult;
import io.jenetics.ext.TreeGene;
import io.jenetics.ext.util.FlatTreeNode;
import io.jenetics.ext.util.Tree;
import io.jenetics.ext.util.TreeNode;
import io.jenetics.internal.math.Probabilities;
import io.jenetics.util.ISeq;
import java.util.random.RandomGenerator;

public abstract class TreeMutator<A, G extends TreeGene<A, G>, C extends Comparable<? super C>>
extends Mutator<G, C> {
    public TreeMutator() {
        this(0.2);
    }

    public TreeMutator(double probability) {
        super(probability);
    }

    protected MutatorResult<Chromosome<G>> mutate(Chromosome<G> chromosome, double p, RandomGenerator random) {
        int P = Probabilities.toInt((double)p);
        return random.nextInt() < P ? this.mutate(chromosome) : new MutatorResult(chromosome, 0);
    }

    private MutatorResult<Chromosome<G>> mutate(Chromosome<G> chromosome) {
        TreeNode tree = TreeNode.ofTree((Tree)chromosome.gene());
        this.mutate(tree);
        FlatTreeNode flat = FlatTreeNode.ofTree(tree);
        ISeq<TreeGene> genes = flat.map(t -> ((TreeGene)chromosome.gene()).newInstance(t));
        return new MutatorResult((Object)chromosome.newInstance(genes), 1);
    }

    protected abstract void mutate(TreeNode<A> var1);
}

