/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext;

import io.jenetics.AltererResult;
import io.jenetics.Chromosome;
import io.jenetics.Gene;
import io.jenetics.Genotype;
import io.jenetics.Mutator;
import io.jenetics.MutatorResult;
import io.jenetics.Phenotype;
import io.jenetics.util.ISeq;
import io.jenetics.util.RandomRegistry;
import io.jenetics.util.Seq;
import java.util.random.RandomGenerator;

public class WeaselMutator<G extends Gene<?, G>, C extends Comparable<? super C>>
extends Mutator<G, C> {
    public WeaselMutator(double probability) {
        super(probability);
    }

    public WeaselMutator() {
        this(0.05);
    }

    public AltererResult<G, C> alter(Seq<Phenotype<G, C>> population, long generation) {
        RandomGenerator random = RandomRegistry.random();
        Seq result = population.map(pt -> this.mutate((Phenotype)pt, generation, this._probability, random));
        return new AltererResult(result.map(MutatorResult::result).asISeq(), result.stream().mapToInt(MutatorResult::mutations).sum());
    }

    protected MutatorResult<Genotype<G>> mutate(Genotype<G> genotype, double p, RandomGenerator random) {
        ISeq result = (ISeq)genotype.stream().map(gt -> this.mutate((Chromosome)gt, p, random)).collect(ISeq.toISeq());
        return new MutatorResult((Object)Genotype.of((Iterable)result.map(MutatorResult::result)), result.stream().mapToInt(MutatorResult::mutations).sum());
    }

    public String toString() {
        return String.format("WeaselMutator[%f]", this._probability);
    }
}

