/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext;

import io.jenetics.Gene;
import io.jenetics.Optimize;
import io.jenetics.Phenotype;
import io.jenetics.Selector;
import io.jenetics.stat.MinMax;
import io.jenetics.util.ISeq;
import io.jenetics.util.MSeq;
import io.jenetics.util.Seq;
import java.util.Comparator;
import java.util.Objects;

public class WeaselSelector<G extends Gene<?, G>, C extends Comparable<? super C>>
implements Selector<G, C> {
    public ISeq<Phenotype<G, C>> select(Seq<Phenotype<G, C>> population, int count, Optimize opt) {
        Objects.requireNonNull(population, "Population");
        Objects.requireNonNull(opt, "Optimization");
        if (count < 0) {
            throw new IllegalArgumentException(String.format("Selection count must be greater or equal then zero, but was %s", count));
        }
        MinMax minMax = (MinMax)population.stream().collect(MinMax.toMinMax((Comparator)opt.ascending()));
        MSeq result = MSeq.ofLength((int)count);
        return result.fill(() -> ((MinMax)minMax).max()).toISeq();
    }

    public String toString() {
        return "WeaselSelector";
    }
}

