/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.engine;

import io.jenetics.Alterer;
import io.jenetics.Gene;
import io.jenetics.engine.Engine;
import io.jenetics.engine.EvolutionResult;
import io.jenetics.engine.EvolutionStreamable;
import io.jenetics.stat.DoubleMomentStatistics;
import io.jenetics.util.DoubleRange;
import java.util.Objects;
import java.util.function.Function;

final class FitnessVarianceAdaptiveEngine<G extends Gene<?, G>, N extends Number>
implements Function<EvolutionResult<G, N>, EvolutionStreamable<G, N>> {
    private final DoubleRange _variance;
    private final Engine.Builder<G, N> _builder;
    private final Alterer<G, N> _narrow;
    private final Alterer<G, N> _enlarge;
    private Engine<G, N> _engine;
    private boolean _narrowing;

    FitnessVarianceAdaptiveEngine(DoubleRange variance, Engine.Builder<G, N> builder, Alterer<G, N> narrow, Alterer<G, N> enlarge) {
        this._variance = Objects.requireNonNull(variance);
        this._builder = Objects.requireNonNull(builder).copy();
        this._narrow = Objects.requireNonNull(narrow);
        this._enlarge = Objects.requireNonNull(enlarge);
    }

    @Override
    public EvolutionStreamable<G, N> apply(EvolutionResult<G, N> result) {
        if (result == null || this._engine == null) {
            this._engine = this._builder.alterers(this._enlarge, new Alterer[0]).build();
            this._narrowing = false;
        } else {
            DoubleMomentStatistics stat = new DoubleMomentStatistics();
            result.population().forEach(pt -> stat.accept(((Number)((Object)pt.fitness())).doubleValue()));
            if (stat.variance() < this._variance.min() && this._narrowing) {
                this._engine = this._builder.alterers(this._enlarge, new Alterer[0]).build();
                this._narrowing = false;
            } else if (stat.variance() > this._variance.max() && !this._narrowing) {
                this._engine = this._builder.alterers(this._narrow, new Alterer[0]).build();
                this._narrowing = true;
            }
        }
        assert (this._engine != null);
        return this._engine;
    }
}

