/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.grammar;

import io.jenetics.ext.grammar.BnfParser;
import io.jenetics.ext.grammar.BnfTokenizer;
import io.jenetics.ext.grammar.Cfg;
import io.jenetics.ext.internal.parser.CharSequenceTokenizer;
import java.util.stream.Collectors;

public final class Bnf {
    private Bnf() {
    }

    static boolean isSymbolChar(int ch) {
        return switch (ch) {
            case 58, 60, 61, 62, 124 -> true;
            default -> false;
        };
    }

    static boolean isStringChar(char c) {
        return !Character.isWhitespace(c) && !Bnf.isSymbolChar(c);
    }

    static boolean isIdChar(char c) {
        return CharSequenceTokenizer.isAlphabetic(c) || Character.isDigit(c) || c == '-';
    }

    public static Cfg<String> parse(String grammar) {
        BnfTokenizer tokenizer = new BnfTokenizer(grammar);
        BnfParser parser = new BnfParser(tokenizer);
        return parser.parse();
    }

    public static String format(Cfg<?> grammar) {
        return grammar.rules().stream().map(Bnf::format).collect(Collectors.joining("\n"));
    }

    private static String format(Cfg.Rule<?> rule) {
        return String.format("%s ::= %s", Bnf.format(rule.start()), rule.alternatives().stream().map(Bnf::format).collect(Collectors.joining("\n    | ")));
    }

    private static String format(Cfg.Expression<?> expr) {
        return expr.symbols().stream().map(Bnf::format).collect(Collectors.joining(" "));
    }

    private static String format(Cfg.Symbol<?> symbol) {
        if (symbol instanceof Cfg.NonTerminal) {
            Cfg.NonTerminal nt = (Cfg.NonTerminal)symbol;
            return String.format("<%s>", nt.name());
        }
        if (symbol instanceof Cfg.Terminal) {
            Cfg.Terminal t = (Cfg.Terminal)symbol;
            return "'" + t.name().replace("\\", "\\\\").replace("'", "\\'") + "'";
        }
        throw new AssertionError();
    }
}

