/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.grammar;

import io.jenetics.ext.grammar.Bnf;
import io.jenetics.ext.internal.parser.CharSequenceTokenizer;
import io.jenetics.ext.internal.parser.ParsingException;
import io.jenetics.ext.internal.parser.Token;

final class BnfTokenizer
extends CharSequenceTokenizer {
    BnfTokenizer(CharSequence input) {
        super(input);
    }

    @Override
    public Token<String> next() {
        block8: while (BnfTokenizer.isNonEof(this.c)) {
            char value = this.c;
            switch (value) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.WS();
                    continue block8;
                }
                case ':': {
                    return this.ASSIGN();
                }
                case '|': {
                    this.consume();
                    return BnfTokenType.BAR.token(value);
                }
                case '>': {
                    this.consume();
                    return BnfTokenType.GT.token(value);
                }
                case '<': {
                    this.consume();
                    return BnfTokenType.LT.token(value);
                }
                case '\'': {
                    return this.QUOTED_STRING();
                }
            }
            if (BnfTokenizer.isAlphabetic(this.c)) {
                return this.ID();
            }
            if (!Character.isWhitespace(this.c)) {
                return this.STRING();
            }
            throw new ParsingException(String.format("Got invalid character '%s' at position '%d'.", Character.valueOf(this.c), this.pos));
        }
        return null;
    }

    private Token<String> ASSIGN() {
        this.match(':');
        this.match(':');
        this.match('=');
        return BnfTokenType.ASSIGN.token("::=");
    }

    private Token<String> QUOTED_STRING() {
        StringBuilder value = new StringBuilder();
        this.match('\'');
        while (BnfTokenizer.isNonEof(this.c) && this.c != '\'') {
            if (this.c == '\\') {
                this.consume();
            }
            value.append(this.c);
            this.consume();
        }
        this.match('\'');
        return BnfTokenType.QUOTED_STRING.token(value.toString());
    }

    private Token<String> ID() {
        StringBuilder value = new StringBuilder();
        while (Bnf.isIdChar(this.c)) {
            value.append(this.c);
            this.consume();
        }
        return BnfTokenType.ID.token(value.toString());
    }

    private Token<String> STRING() {
        StringBuilder value = new StringBuilder();
        while (BnfTokenizer.isNonEof(this.c) && Bnf.isStringChar(this.c)) {
            value.append(this.c);
            this.consume();
        }
        return BnfTokenType.STRING.token(value.toString());
    }

    static enum BnfTokenType implements Token.Type
    {
        ASSIGN(1),
        BAR(2),
        GT(3),
        LT(4),
        ID(5),
        STRING(6),
        QUOTED_STRING(7);

        private final int _code;

        private BnfTokenType(int code) {
            this._code = code;
        }

        @Override
        public int code() {
            return this._code;
        }
    }
}

