/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.grammar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public record Cfg<T>(List<NonTerminal<T>> nonTerminals, List<Terminal<T>> terminals, List<Rule<T>> rules, NonTerminal<T> start) {
    public Cfg {
        if (rules.isEmpty()) {
            throw new IllegalArgumentException("The given list of rules must not be empty.");
        }
        List<String> duplicatedRules = rules.stream().collect(Collectors.groupingBy(Rule::start)).values().stream().filter(values -> values.size() > 1).map((? super T rule) -> ((Rule)rule.get((int)0)).start.name).toList();
        if (!duplicatedRules.isEmpty()) {
            throw new IllegalArgumentException("Found duplicate rule(s), " + duplicatedRules + ".");
        }
        Optional<Rule> startRule = rules.stream().filter(r -> start.equals(r.start)).findFirst();
        if (startRule.isEmpty()) {
            throw new IllegalArgumentException("No rule found for start symbol %s.".formatted(start));
        }
        Set required = rules.stream().flatMap(Cfg::ruleSymbols).collect(Collectors.toUnmodifiableSet());
        Set available = Stream.concat(nonTerminals.stream(), terminals.stream()).collect(Collectors.toUnmodifiableSet());
        HashSet missing = new HashSet(required);
        missing.removeAll(available);
        if (!missing.isEmpty()) {
            throw new IllegalArgumentException("Unknown symbols defined in rules: " + missing);
        }
        Set terminalNames = terminals.stream().map(Symbol::name).collect(Collectors.toSet());
        Set nonTerminalNames = nonTerminals.stream().map(Symbol::name).collect(Collectors.toSet());
        terminalNames.retainAll(nonTerminalNames);
        if (!terminalNames.isEmpty()) {
            throw new IllegalArgumentException(String.format("Terminal and non-terminal symbols with same name: %s", terminalNames.stream().sorted().toList()));
        }
        nonTerminals = List.copyOf(nonTerminals);
        terminals = List.copyOf(terminals);
        rules = List.copyOf(rules);
        Objects.requireNonNull(start);
    }

    public Optional<Rule<T>> rule(NonTerminal<?> start) {
        Objects.requireNonNull(start);
        for (Rule<T> rule : this.rules) {
            if (!rule.start().name().equals(start.name())) continue;
            return Optional.of(rule);
        }
        return Optional.empty();
    }

    public <A> Cfg<A> map(Function<? super Terminal<T>, ? extends A> mapper) {
        Objects.requireNonNull(mapper);
        HashMap cache = new HashMap();
        Function<Terminal, Terminal> mapping = t -> cache.computeIfAbsent(t, t2 -> new Terminal(t2.name(), mapper.apply((Object)t2)));
        List<Rule<T>> rules = this.rules().stream().map((? super T rule) -> new Rule(rule.start(), rule.alternatives().stream().map((? super T expr) -> new Expression(expr.symbols().stream().map((? super T sym) -> {
            Symbol symbol;
            if (sym instanceof Terminal) {
                Terminal t = (Terminal)sym;
                symbol = (Symbol)mapping.apply(t);
            } else {
                symbol = sym;
            }
            return symbol;
        }).toList())).toList())).toList();
        return Cfg.of(rules);
    }

    public static <T> Cfg<T> of(List<Rule<T>> rules) {
        if (rules.isEmpty()) {
            throw new IllegalArgumentException("The list of rules must not be empty.");
        }
        List<Rule<T>> normalizedRules = Cfg.normalize(rules);
        List symbols = normalizedRules.stream().flatMap(Cfg::ruleSymbols).distinct().toList();
        List<NonTerminal<T>> nonTerminals = symbols.stream().filter(NonTerminal.class::isInstance).map((? super T nt) -> (NonTerminal)nt).toList();
        List<Terminal<T>> terminals = symbols.stream().filter(Terminal.class::isInstance).map((? super T nt) -> (Terminal)nt).toList();
        return new Cfg<T>(nonTerminals, terminals, normalizedRules.stream().map((? super T r) -> Cfg.rebuild(r, symbols)).toList(), (NonTerminal)Cfg.select(normalizedRules.get(0).start(), symbols));
    }

    @SafeVarargs
    public static <T> Cfg<T> of(Rule<T> ... rules) {
        return Cfg.of(List.of(rules));
    }

    private static <T> List<Rule<T>> normalize(List<Rule<T>> rules) {
        Map grouped = rules.stream().collect(Collectors.groupingBy(Rule::start, LinkedHashMap::new, Collectors.toCollection(ArrayList::new)));
        return grouped.entrySet().stream().map((? super T entry) -> Cfg.merge((NonTerminal)entry.getKey(), (List)entry.getValue())).toList();
    }

    private static <T> Rule<T> merge(NonTerminal<T> start, List<Rule<T>> rules) {
        return new Rule<T>(start, rules.stream().flatMap(rule -> rule.alternatives().stream()).toList());
    }

    private static <T> Stream<Symbol<T>> ruleSymbols(Rule<T> rule) {
        return Stream.concat(Stream.of(rule.start), rule.alternatives.stream().flatMap(expr -> expr.symbols().stream()));
    }

    private static <T> Rule<T> rebuild(Rule<T> rule, List<Symbol<T>> symbols) {
        return new Rule((NonTerminal)Cfg.select(rule.start, symbols), rule.alternatives.stream().map((? super T e) -> Cfg.rebuild(e, symbols)).toList());
    }

    private static <T> Expression<T> rebuild(Expression<T> expression, List<Symbol<T>> symbols) {
        return new Expression(expression.symbols.stream().map((? super T s) -> Cfg.select(s, symbols)).toList());
    }

    private static <T> Symbol<T> select(Symbol<T> symbol, List<Symbol<T>> symbols) {
        for (Symbol<T> s : symbols) {
            if (!s.name().equals(symbol.name())) continue;
            return s;
        }
        throw new AssertionError((Object)("Symbol not found: " + symbol));
    }

    static <A, B extends A> Cfg<A> upcast(Cfg<B> seq) {
        return seq;
    }

    public static <T> Terminal<T> T(String name, T value) {
        return new Terminal<T>(name, value);
    }

    public static Terminal<String> T(String name) {
        return new Terminal<String>(name, name);
    }

    public static <T> NonTerminal<T> N(String name) {
        return new NonTerminal(name);
    }

    @SafeVarargs
    public static <T> Expression<T> E(Symbol<T> ... symbols) {
        return new Expression<T>(List.of(symbols));
    }

    @SafeVarargs
    public static <T> Rule<T> R(String name, Expression<T> ... alternatives) {
        return new Rule(new NonTerminal(name), List.of(alternatives));
    }

    public record NonTerminal<T>(String name) implements Symbol<T>
    {
        public NonTerminal {
            if (name.isEmpty()) {
                throw new IllegalArgumentException("Non-terminal value must not be empty.");
            }
        }
    }

    public record Rule<T>(NonTerminal<T> start, List<Expression<T>> alternatives) {
        public Rule {
            Objects.requireNonNull(start);
            if (alternatives.isEmpty()) {
                throw new IllegalArgumentException("Rule alternatives must not be empty.");
            }
            alternatives = List.copyOf(alternatives);
        }
    }

    public record Terminal<T>(String name, T value) implements Symbol<T>
    {
        public Terminal {
            if (name.isEmpty()) {
                throw new IllegalArgumentException("Terminal value must not be empty.");
            }
        }

        public static Terminal<String> of(String name) {
            return new Terminal<String>(name, name);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Symbol<T> {
        public String name();
    }

    public record Expression<T>(List<Symbol<T>> symbols) {
        public Expression {
            if (symbols.isEmpty()) {
                throw new IllegalArgumentException("The list of symbols must not be empty.");
            }
            symbols = List.copyOf(symbols);
        }
    }
}

