/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.grammar;

import io.jenetics.BitChromosome;
import io.jenetics.BitGene;
import io.jenetics.IntegerGene;
import io.jenetics.ext.grammar.Cfg;
import io.jenetics.ext.grammar.SymbolIndex;
import io.jenetics.internal.util.Bits;
import io.jenetics.internal.util.Requires;
import io.jenetics.util.BaseSeq;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;

public final class Codons
implements SymbolIndex {
    private final IntUnaryOperator _values;
    private final int _length;
    private final AtomicInteger _pos = new AtomicInteger(0);

    public Codons(IntUnaryOperator codons, int length) {
        this._values = Objects.requireNonNull(codons);
        this._length = Requires.positive((int)length);
    }

    @Override
    public int next(Cfg.Rule<?> rule, int bound) {
        int index = this._pos.getAndUpdate(x -> (x + 1) % this._length);
        return this._values.applyAsInt(index) % bound;
    }

    public static Codons ofBitGenes(BaseSeq<BitGene> genes) {
        if (genes instanceof BitChromosome) {
            BitChromosome ch = (BitChromosome)genes;
            return Codons.ofBytes(ch.toByteArray());
        }
        return Codons.ofBytes(Codons.toByteArray(genes));
    }

    private static Codons ofBytes(byte[] bytes) {
        int[] values = new int[bytes.length];
        for (int i2 = 0; i2 < values.length; ++i2) {
            values[i2] = Byte.toUnsignedInt(bytes[i2]);
        }
        return new Codons(i -> values[i], values.length);
    }

    static byte[] toByteArray(BaseSeq<BitGene> genes) {
        byte[] bytes = Bits.newArray((int)genes.length());
        for (int i = 0; i < genes.length(); ++i) {
            if (!((BitGene)genes.get(i)).booleanValue()) continue;
            Bits.set((byte[])bytes, (int)i);
        }
        return bytes;
    }

    public static Codons ofIntegerGenes(BaseSeq<IntegerGene> genes) {
        return new Codons(i -> ((IntegerGene)genes.get(i)).intValue(), genes.length());
    }
}

