/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.grammar;

import io.jenetics.Genotype;
import io.jenetics.IntegerChromosome;
import io.jenetics.IntegerGene;
import io.jenetics.engine.Codec;
import io.jenetics.ext.grammar.Cfg;
import io.jenetics.ext.grammar.Codons;
import io.jenetics.ext.grammar.Generator;
import io.jenetics.ext.grammar.SymbolIndex;
import io.jenetics.util.BaseSeq;
import io.jenetics.util.Factory;
import io.jenetics.util.ISeq;
import io.jenetics.util.IntRange;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

final class MultiIntegerChromosomeMapper<T, R>
implements Codec<R, IntegerGene> {
    private final Factory<Genotype<IntegerGene>> _encoding;
    private final Function<Genotype<IntegerGene>, R> _decoder;

    public MultiIntegerChromosomeMapper(Cfg<? extends T> cfg, Function<? super Cfg.Rule<?>, IntRange> length, Function<? super SymbolIndex, ? extends Generator<T, R>> generator) {
        this._encoding = Genotype.of((Iterable)((Iterable)cfg.rules().stream().map(rule -> IntegerChromosome.of((IntRange)IntRange.of((int)0, (int)rule.alternatives().size()), (IntRange)((IntRange)length.apply((Cfg.Rule<?>)rule)))).collect(ISeq.toISeq())));
        CodonsFactory codons = new CodonsFactory(cfg);
        this._decoder = gt -> ((Generator)generator.apply(codons.get((Genotype<IntegerGene>)gt))).generate(cfg);
    }

    public Factory<Genotype<IntegerGene>> encoding() {
        return this._encoding;
    }

    public Function<Genotype<IntegerGene>, R> decoder() {
        return this._decoder;
    }

    private static final class CodonsFactory {
        private final Map<String, Integer> _rulesIndex;

        CodonsFactory(Cfg<?> cfg) {
            this._rulesIndex = IntStream.range(0, cfg.rules().size()).mapToObj(i -> Map.entry(cfg.rules().get(i).start().name(), i)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        SymbolIndex get(Genotype<IntegerGene> gt) {
            CodonsCache codons = new CodonsCache(gt);
            return (rule, bound) -> codons.get(this._rulesIndex.get(rule.start().name())).next(rule, bound);
        }

        private static final class CodonsCache {
            private final Genotype<IntegerGene> _genotype;
            private final Codons[] _codons;

            CodonsCache(Genotype<IntegerGene> genotype) {
                this._genotype = Objects.requireNonNull(genotype);
                this._codons = new Codons[genotype.length()];
            }

            Codons get(int index) {
                Codons result = this._codons[index];
                if (result == null) {
                    this._codons[index] = result = Codons.ofIntegerGenes((BaseSeq<IntegerGene>)this._genotype.get(index));
                }
                return result;
            }
        }
    }
}

