/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.internal.parser;

import io.jenetics.ext.internal.parser.ParsingException;
import io.jenetics.ext.internal.parser.Token;
import io.jenetics.ext.internal.parser.Tokenizer;
import java.util.Objects;

public abstract class CharSequenceTokenizer
implements Tokenizer<Token<String>> {
    private static final char EOF = '\uffff';
    private final CharSequence _input;
    protected int pos = 0;
    protected char c = (char)65535;

    protected CharSequenceTokenizer(CharSequence input) {
        Objects.requireNonNull(input);
        if (input.length() > 0) {
            this.c = input.charAt(0);
        }
        this._input = input;
    }

    protected void match(char ch) {
        if (ch != this.c) {
            throw new ParsingException(String.format("Got invalid character '%s' at position '%d'; expected '%s'", Character.valueOf(this.c), this.pos, Character.valueOf(ch)));
        }
        this.consume();
    }

    protected void consume() {
        this.c = this.pos + 1 >= this._input.length() ? (char)65535 : this._input.charAt(++this.pos);
    }

    protected char LA(int index) {
        int i = this.pos + index - 1;
        return i < this._input.length() && i >= 0 ? this._input.charAt(i) : (char)'\uffff';
    }

    public static boolean isNonEof(char ch) {
        return ch != '\uffff';
    }

    public static boolean isAlphabetic(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
    }

    protected void WS() {
        do {
            this.consume();
        } while (CharSequenceTokenizer.isNonEof(this.c) && Character.isWhitespace(this.c));
    }
}

