/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.internal.util;

import io.jenetics.ext.internal.util.ConcatSpliterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class CyclicSpliterator<T>
implements Spliterator<T> {
    private final List<Supplier<Spliterator<T>>> _spliterators;
    private ConcatSpliterator<T> _concat = null;

    public CyclicSpliterator(List<Supplier<Spliterator<T>>> spliterators) {
        spliterators.forEach(Objects::requireNonNull);
        this._spliterators = new ArrayList<Supplier<Spliterator<T>>>(spliterators);
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        boolean advance = true;
        if (this._spliterators.isEmpty()) {
            advance = false;
        } else if (!this.spliterator().tryAdvance(action)) {
            this._concat = null;
        }
        return advance;
    }

    @Override
    public Spliterator<T> trySplit() {
        return new CyclicSpliterator<T>(this._spliterators);
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 16;
    }

    private ConcatSpliterator<T> spliterator() {
        if (this._concat == null) {
            this._concat = new ConcatSpliterator(this._spliterators.stream().map(Supplier::get).toList());
        }
        return this._concat;
    }
}

