/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.internal.util;

import io.jenetics.ext.internal.parser.Parser;
import io.jenetics.ext.internal.parser.ParsingException;
import io.jenetics.ext.util.TreeNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class FormulaParser<T> {
    private final Predicate<? super T> _lparen;
    private final Predicate<? super T> _rparen;
    private final Predicate<? super T> _separator;
    private final Predicate<? super T> _uops;
    private final Predicate<? super T> _identifiers;
    private final Predicate<? super T> _functions;
    private final Term<T> _term;

    private FormulaParser(Predicate<? super T> lparen, Predicate<? super T> rparen, Predicate<? super T> separator, List<? extends Predicate<? super T>> bops, Predicate<? super T> uops, Predicate<? super T> identifiers, Predicate<? super T> functions) {
        this._lparen = Objects.requireNonNull(lparen);
        this._rparen = Objects.requireNonNull(rparen);
        this._separator = Objects.requireNonNull(separator);
        this._uops = Objects.requireNonNull(uops);
        this._identifiers = Objects.requireNonNull(identifiers);
        this._functions = Objects.requireNonNull(functions);
        BopTerm oterm = BopTerm.build(bops);
        Term fterm = new Term<T>(){

            @Override
            <V> TreeNode<V> term(Parser<T> parser, TokenConverter<? super T, ? extends V> mapper) {
                return FormulaParser.this.function(parser, mapper);
            }
        };
        if (oterm != null) {
            oterm.append(fterm);
            this._term = oterm;
        } else {
            this._term = fterm;
        }
    }

    private <V> TreeNode<V> function(Parser<T> parser, TokenConverter<? super T, ? extends V> mapper) {
        T token = parser.LT(1);
        if (this._functions.test(token)) {
            parser.consume();
            TreeNode<V> node = TreeNode.of(mapper.convert(token, TokenType.FUNCTION));
            parser.match(this._lparen);
            node.attach((V)this._term.expr(parser, mapper));
            while (this._separator.test(parser.LT(1))) {
                parser.consume();
                node.attach((V)this._term.expr(parser, mapper));
            }
            parser.match(this._rparen);
            return node;
        }
        if (this._lparen.test(token)) {
            parser.consume();
            TreeNode<? extends V> node = this._term.expr(parser, mapper);
            parser.match(this._rparen);
            return node;
        }
        return this.unary(() -> this.atom(parser, mapper), parser, mapper);
    }

    private <V> TreeNode<V> atom(Parser<T> parser, TokenConverter<? super T, ? extends V> mapper) {
        T token = parser.LT(1);
        if (this._identifiers.test(token)) {
            parser.consume();
            return TreeNode.of(mapper.convert(token, TokenType.IDENTIFIER));
        }
        if (token == null) {
            throw new ParsingException("Unexpected end of input.");
        }
        throw new ParsingException("Unexpected symbol found: %s.".formatted(parser.LT(1)));
    }

    private <V> TreeNode<V> unary(Supplier<TreeNode<V>> other, Parser<T> parser, TokenConverter<? super T, ? extends V> mapper) {
        T token = parser.LT(1);
        if (this._uops.test(token)) {
            parser.consume();
            return TreeNode.of(mapper.convert(token, TokenType.UNARY_OPERATOR)).attach((V)other.get());
        }
        return other.get();
    }

    public <V> TreeNode<V> parse(Supplier<? extends T> tokens, TokenConverter<? super T, ? extends V> mapper) {
        Objects.requireNonNull(tokens);
        Objects.requireNonNull(mapper);
        return this._term.expr(new Parser<Object>(tokens::get, 1), mapper);
    }

    public TreeNode<T> parse(Supplier<? extends T> tokens) {
        return this.parse(tokens, (? super T token, TokenType type) -> token);
    }

    public <V> TreeNode<V> parse(Iterable<? extends T> tokens, TokenConverter<? super T, ? extends V> mapper) {
        Iterator it = tokens.iterator();
        return this.parse(() -> it.hasNext() ? it.next() : null, mapper);
    }

    public TreeNode<T> parse(Iterable<? extends T> tokens) {
        return this.parse(tokens, (? super T token, TokenType type) -> token);
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    private static class BopTerm<T>
    extends Term<T> {
        private final Predicate<? super T> _tokens;

        BopTerm(Predicate<? super T> tokens) {
            this._tokens = Objects.requireNonNull(tokens);
        }

        @Override
        <V> TreeNode<V> op(TreeNode<V> expr, Parser<T> parser, TokenConverter<? super T, ? extends V> mapper) {
            TreeNode<Object> result = expr;
            T token = parser.LT(1);
            if (token != null && this._tokens.test(token)) {
                parser.consume();
                TreeNode<TreeNode<? extends V>> node = TreeNode.of(mapper.convert(token, TokenType.BINARY_OPERATOR)).attach((V)expr).attach((TreeNode<V>)this.term(parser, mapper));
                result = this.op(node, parser, mapper);
            }
            return result;
        }

        @Override
        <V> TreeNode<V> term(Parser<T> parser, TokenConverter<? super T, ? extends V> mapper) {
            return this._next.op(this._next.term(parser, mapper), parser, mapper);
        }

        static <T> BopTerm<T> build(List<? extends Predicate<? super T>> bops) {
            BopTerm<T> start = null;
            for (Predicate<T> predicate : bops) {
                BopTerm<T> term = new BopTerm<T>(predicate);
                if (start == null) {
                    start = term;
                    continue;
                }
                start.append(term);
            }
            return start;
        }
    }

    private static abstract class Term<T> {
        Term<T> _next;
        Term<T> _last;

        private Term() {
        }

        <V> TreeNode<V> op(TreeNode<V> expr, Parser<T> parser, TokenConverter<? super T, ? extends V> mapper) {
            return expr;
        }

        abstract <V> TreeNode<V> term(Parser<T> var1, TokenConverter<? super T, ? extends V> var2);

        <V> TreeNode<V> expr(Parser<T> parser, TokenConverter<? super T, ? extends V> mapper) {
            return this.op(this.term(parser, mapper), parser, mapper);
        }

        void append(Term<T> term) {
            if (this._next == null) {
                this._next = term;
                this._last = term;
            } else {
                this._last.append(term);
            }
        }
    }

    public static enum TokenType {
        UNARY_OPERATOR,
        BINARY_OPERATOR,
        FUNCTION,
        IDENTIFIER;

    }

    @FunctionalInterface
    public static interface TokenConverter<T, V> {
        public V convert(T var1, TokenType var2);
    }

    public static final class Builder<T> {
        private Predicate<? super T> _lparen = token -> false;
        private Predicate<? super T> _rparen = token -> false;
        private Predicate<? super T> _separator = token -> false;
        private List<? extends Predicate<? super T>> _bops = List.of();
        private Predicate<? super T> _uops = token -> false;
        private Predicate<? super T> _identifiers = token -> false;
        private Predicate<? super T> _functions = token -> false;

        private Builder() {
        }

        public Builder<T> lparen(Predicate<? super T> lparen) {
            this._lparen = Objects.requireNonNull(lparen);
            return this;
        }

        public Builder<T> lparen(T lparen) {
            return this.lparen((T)((Predicate<Object>)token -> Objects.equals(token, lparen)));
        }

        public Builder<T> rparen(Predicate<? super T> rparen) {
            this._rparen = Objects.requireNonNull(rparen);
            return this;
        }

        public Builder<T> rparen(T rparen) {
            return this.rparen((T)((Predicate<Object>)token -> Objects.equals(token, rparen)));
        }

        public Builder<T> separator(Predicate<? super T> separator) {
            this._separator = Objects.requireNonNull(separator);
            return this;
        }

        public Builder<T> separator(T separator) {
            return this.separator((T)((Predicate<Object>)token -> Objects.equals(token, separator)));
        }

        public Builder<T> unaryOperators(Predicate<? super T> ops) {
            this._uops = Objects.requireNonNull(ops);
            return this;
        }

        public Builder<T> unaryOperators(Set<? extends T> ops) {
            return this.unaryOperators(Set.copyOf(ops)::contains);
        }

        @SafeVarargs
        public final Builder<T> unaryOperators(T ... ops) {
            return this.unaryOperators(Set.of(ops));
        }

        public Builder<T> binaryOperators(List<? extends Predicate<? super T>> ops) {
            this._bops = List.copyOf(ops);
            return this;
        }

        @SafeVarargs
        public final Builder<T> binaryOperators(Predicate<? super T> ... ops) {
            this._bops = List.of(ops);
            return this;
        }

        public Builder<T> binaryOperators(Consumer<? super Bops<T>> ops) {
            Bops builder = new Bops();
            ops.accept(builder);
            this._bops = builder.build();
            return this;
        }

        public Builder<T> identifiers(Predicate<? super T> identifiers) {
            this._identifiers = Objects.requireNonNull(identifiers);
            return this;
        }

        public Builder<T> identifiers(Set<? extends T> identifiers) {
            return this.identifiers(Set.copyOf(identifiers)::contains);
        }

        @SafeVarargs
        public final Builder<T> identifiers(T ... identifiers) {
            return this.identifiers(Set.of(identifiers));
        }

        public Builder<T> functions(Predicate<? super T> functions) {
            this._functions = Objects.requireNonNull(functions);
            return this;
        }

        public Builder<T> functions(Set<? extends T> functions) {
            return this.functions(Set.copyOf(functions)::contains);
        }

        @SafeVarargs
        public final Builder<T> functions(T ... functions) {
            return this.functions(Set.of(functions));
        }

        public FormulaParser<T> build() {
            return new FormulaParser<T>(this._lparen, this._rparen, this._separator, this._bops, this._uops, this._identifiers, this._functions);
        }

        public static final class Bops<T> {
            private final Map<Integer, Predicate<? super T>> _operations = new HashMap<Integer, Predicate<? super T>>();

            private Bops() {
            }

            public Bops<T> add(int precedence, Predicate<? super T> operators) {
                Predicate<Object> ops = this._operations.get(precedence);
                if (ops != null) {
                    Predicate prev = ops;
                    ops = token -> prev.test(token) || operators.test(token);
                } else {
                    ops = operators;
                }
                this._operations.put(precedence, ops);
                return this;
            }

            @SafeVarargs
            public final Bops<T> add(int precedence, T ... operators) {
                return this.add(precedence, Set.of(operators)::contains);
            }

            private List<? extends Predicate<? super T>> build() {
                return this._operations.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).toList();
            }
        }
    }
}

