/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.internal.util;

import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;

public class GeneratorSpliterator<T>
implements Spliterator<T> {
    private final Function<? super T, ? extends Spliterator<T>> _generator;
    private Spliterator<T> _current;
    private T _element;

    public GeneratorSpliterator(Function<? super T, ? extends Spliterator<T>> generator) {
        this._generator = Objects.requireNonNull(generator);
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        boolean advance = this.spliterator().tryAdvance(element -> {
            action.accept(element);
            this._element = element;
        });
        if (!advance) {
            this._current = null;
        }
        return true;
    }

    @Override
    public Spliterator<T> trySplit() {
        return new GeneratorSpliterator<T>(this._generator);
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 16;
    }

    private Spliterator<T> spliterator() {
        if (this._current == null) {
            this._current = this._generator.apply(this._element);
        }
        return this._current;
    }
}

