/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.moea;

import io.jenetics.Optimize;
import io.jenetics.ext.moea.ElementComparator;
import io.jenetics.ext.moea.ElementDistance;
import io.jenetics.ext.moea.GeneralObjectVec;
import io.jenetics.ext.moea.Pareto;
import io.jenetics.ext.moea.Vec;
import io.jenetics.ext.moea.VecFactory;
import io.jenetics.ext.moea.Vecs;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

final class GeneralObjectVecFactory<T>
implements VecFactory<T[]> {
    private final boolean[] _maximisations;
    private final Comparator<? super T> _comp;
    private final ElementDistance<T[]> _dist;
    private final ElementComparator<T[]> _comparator = this::cmp;
    private final ElementDistance<T[]> _distance = this::dst;
    private final Comparator<T[]> _dominance = this::dom;

    GeneralObjectVecFactory(Comparator<? super T> comparator, ElementDistance<T[]> distance, List<Optimize> optimizes) {
        Vecs.checkVecLength(optimizes.size());
        this._maximisations = Vecs.toFlags(optimizes);
        this._comp = Objects.requireNonNull(comparator);
        this._dist = Objects.requireNonNull(distance);
    }

    private int cmp(T[] u, T[] v, int i) {
        return this._maximisations[i] ? this._comp.compare(u[i], v[i]) : this._comp.compare(v[i], u[i]);
    }

    private double dst(T[] u, T[] v, int i) {
        return this._maximisations[i] ? this._dist.distance(u, v, i) : this._dist.distance(v, u, i);
    }

    private int dom(T[] u, T[] v) {
        return Pareto.dominance(u, v, this._maximisations.length, this._comparator);
    }

    @Override
    public Vec<T[]> newVec(T[] array) {
        Vecs.requireVecLength(this._maximisations.length, array.length);
        return new GeneralObjectVec<T>(array, this._comparator, this._distance, this._dominance);
    }

    public String toString() {
        return String.format("VecFactory<T[%d]>", this._maximisations.length);
    }
}

