/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.moea;

import io.jenetics.ext.moea.ElementComparator;
import io.jenetics.ext.moea.ElementDistance;
import io.jenetics.ext.moea.Pareto;
import io.jenetics.ext.moea.SerialProxy;
import io.jenetics.ext.moea.Vec;
import io.jenetics.ext.moea.Vecs;
import io.jenetics.internal.util.SerialIO;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

final class SimpleDoubleVec
implements Vec<double[]>,
Serializable {
    private static final long serialVersionUID = 2L;
    private final double[] _data;

    SimpleDoubleVec(double[] data) {
        Vecs.checkVecLength(data.length);
        this._data = data;
    }

    @Override
    public double[] data() {
        return this._data;
    }

    @Override
    public int length() {
        return this._data.length;
    }

    @Override
    public ElementComparator<double[]> comparator() {
        return SimpleDoubleVec::cmp;
    }

    private static int cmp(double[] u, double[] v, int i) {
        return Double.compare(u[i], v[i]);
    }

    @Override
    public ElementDistance<double[]> distance() {
        return SimpleDoubleVec::dist;
    }

    private static double dist(double[] u, double[] v, int i) {
        return u[i] - v[i];
    }

    @Override
    public Comparator<double[]> dominance() {
        return Pareto::dominance;
    }

    public int hashCode() {
        return Arrays.hashCode(this._data);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof SimpleDoubleVec)) return false;
        SimpleDoubleVec other = (SimpleDoubleVec)obj;
        if (!Arrays.equals(other._data, this._data)) return false;
        return true;
    }

    public String toString() {
        return Arrays.toString(this._data);
    }

    private Object writeReplace() {
        return new SerialProxy(3, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(DataOutput out) throws IOException {
        SerialIO.writeDoubleArray((double[])this._data, (DataOutput)out);
    }

    static SimpleDoubleVec read(DataInput in) throws IOException {
        return new SimpleDoubleVec(SerialIO.readDoubleArray((DataInput)in));
    }
}

